/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.parser;

import org.apache.metamodel.query.parser.QueryPartProcessor;

public final class QueryPartParser {
    private final QueryPartProcessor _processor;
    private final String _clause;
    private final String[] _ItemDelims;

    public QueryPartParser(QueryPartProcessor processor, String clause, String ... itemDelims) {
        if (clause == null) {
            throw new IllegalArgumentException("Clause cannot be null");
        }
        if (itemDelims == null || itemDelims.length == 0) {
            throw new IllegalArgumentException("Item delimiters cannot be null or empty");
        }
        this._processor = processor;
        this._clause = clause;
        this._ItemDelims = itemDelims;
    }

    public void parse() {
        if (this._clause.isEmpty()) {
            return;
        }
        int parenthesisCount = 0;
        int offset = 0;
        boolean singleOuterParenthesis = this._clause.charAt(0) == '(' && this._clause.charAt(this._clause.length() - 1) == ')';
        String previousDelim = null;
        DelimOccurrence nextDelimOccurrence = this.getNextDelim(0);
        if (nextDelimOccurrence != null) {
            for (int i = 0; i < this._clause.length(); ++i) {
                char c = this._clause.charAt(i);
                if (c == '(') {
                    ++parenthesisCount;
                } else if (c == ')' && singleOuterParenthesis && --parenthesisCount == 0 && i != this._clause.length() - 1) {
                    singleOuterParenthesis = false;
                }
                if (i != nextDelimOccurrence.index) continue;
                if (parenthesisCount == 0) {
                    String itemToken = this._clause.substring(offset, i);
                    this.parseItem(previousDelim, itemToken);
                    offset = i + nextDelimOccurrence.delim.length();
                    previousDelim = nextDelimOccurrence.delim;
                }
                if ((nextDelimOccurrence = this.getNextDelim(nextDelimOccurrence.index + 1)) == null) break;
            }
        }
        if (singleOuterParenthesis) {
            String newClause = this._clause.substring(1, this._clause.length() - 1);
            QueryPartParser newParser = new QueryPartParser(this._processor, newClause, this._ItemDelims);
            newParser.parse();
            return;
        }
        if (offset != this._clause.length()) {
            String token = this._clause.substring(offset);
            this.parseItem(previousDelim, token);
        }
    }

    private DelimOccurrence getNextDelim(int offset) {
        DelimOccurrence result = null;
        for (int i = 0; i < this._ItemDelims.length; ++i) {
            String delim = this._ItemDelims[i];
            int index = this._clause.toUpperCase().indexOf(delim, offset);
            if (index == -1 || result != null && index != Math.min(result.index, index)) continue;
            result = new DelimOccurrence();
            result.index = index;
            result.delim = delim;
        }
        return result;
    }

    private void parseItem(String delim, String token) {
        if (token != null && !(token = token.trim()).isEmpty()) {
            this._processor.parse(delim, token);
        }
    }

    private static class DelimOccurrence {
        public int index;
        public String delim;

        private DelimOccurrence() {
        }
    }
}

