/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.JoinType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.parser.QueryParser;
import org.apache.metamodel.query.parser.QueryParserException;
import org.apache.metamodel.query.parser.QueryPartProcessor;
import org.apache.metamodel.query.parser.SelectItemParser;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromItemParser
implements QueryPartProcessor {
    private static final Map<Character, Character> delimiterMap = new HashMap<Character, Character>();
    private static final Logger logger;
    private final Query _query;
    private final DataContext _dataContext;

    public FromItemParser(DataContext dataContext, Query query) {
        this._dataContext = dataContext;
        this._query = query;
    }

    @Override
    public void parse(String delim, String itemToken) {
        FromItem fromItem;
        int parenthesisStart = itemToken.indexOf(40);
        if (parenthesisStart != -1) {
            if (parenthesisStart != 0) {
                throw new QueryParserException("Not capable of parsing FROM token: " + itemToken + ". Expected parenthesis to start at first character.");
            }
            int parenthesisEnd = itemToken.indexOf(41, parenthesisStart);
            if (parenthesisEnd == -1) {
                throw new QueryParserException("Not capable of parsing FROM token: " + itemToken + ". Expected end parenthesis.");
            }
            String subQueryString = itemToken.substring(parenthesisStart + 1, parenthesisEnd);
            logger.debug("Parsing sub-query: {}", (Object)subQueryString);
            Query subQuery = new QueryParser(this._dataContext, subQueryString).parse();
            fromItem = new FromItem(subQuery);
            String alias = itemToken.substring(parenthesisEnd + 1).trim();
            if (!alias.isEmpty()) {
                fromItem.setAlias(alias);
            }
        } else {
            fromItem = itemToken.toUpperCase().indexOf(" JOIN ") != -1 ? this.parseAllJoinItems(itemToken) : this.parseTableItem(itemToken);
        }
        this._query.from(fromItem);
    }

    private FromItem parseTableItem(String itemToken) {
        String aliasToken;
        String tableNameToken;
        char startDelimiter = itemToken.trim().charAt(0);
        if (delimiterMap.containsKey(Character.valueOf(startDelimiter))) {
            char endDelimiter = delimiterMap.get(Character.valueOf(startDelimiter)).charValue();
            int endIndex = itemToken.trim().lastIndexOf(endDelimiter, itemToken.trim().length());
            if (endIndex <= 0) {
                throw new QueryParserException("Not capable of parsing FROM token: " + itemToken + ". Expected end " + endDelimiter);
            }
            tableNameToken = itemToken.trim().substring(1, endIndex).trim();
            aliasToken = itemToken.trim().substring(1 + endIndex).trim().equalsIgnoreCase("") ? null : itemToken.trim().substring(1 + endIndex).trim();
        } else {
            String[] tokens = itemToken.split(" ");
            tableNameToken = tokens[0];
            if (tokens.length == 2) {
                aliasToken = tokens[1];
            } else if (tokens.length == 1) {
                aliasToken = null;
            } else {
                throw new QueryParserException("Not capable of parsing FROM token: " + itemToken);
            }
        }
        Table table = this._dataContext.getTableByQualifiedLabel(tableNameToken);
        if (table == null) {
            throw new QueryParserException("Not capable of parsing FROM token: " + itemToken);
        }
        FromItem result = new FromItem(table);
        result.setAlias(aliasToken);
        result.setQuery(this._query);
        return result;
    }

    private FromItem parseAllJoinItems(String itemToken) {
        String[] joinSplit = itemToken.split("(?i) JOIN ");
        ArrayList<String> joinsList = new ArrayList<String>();
        for (int i = 0; i < joinSplit.length - 1; ++i) {
            joinSplit[i] = joinSplit[i].trim();
            joinSplit[i + 1] = joinSplit[i + 1].trim();
            String leftPart = joinSplit[i].substring(0, joinSplit[i].lastIndexOf(" "));
            String joinType = joinSplit[i].substring(joinSplit[i].lastIndexOf(" "));
            String rightPart = i + 1 == joinSplit.length - 1 ? joinSplit[i + 1] : joinSplit[i + 1].substring(0, joinSplit[i + 1].lastIndexOf(" "));
            joinsList.add((leftPart + " " + joinType + " JOIN " + rightPart).replaceAll(" +", " "));
            String rightTable = rightPart.substring(0, rightPart.toUpperCase().lastIndexOf(" ON "));
            String nextJoinType = joinSplit[i + 1].substring(joinSplit[i + 1].lastIndexOf(" "));
            joinSplit[i + 1] = rightTable + " " + nextJoinType;
        }
        HashSet<FromItem> fromItems = new HashSet<FromItem>();
        FromItem leftFromItem = null;
        for (String token : joinsList) {
            leftFromItem = this.parseJoinItem(leftFromItem, token, fromItems);
        }
        return leftFromItem;
    }

    private FromItem parseJoinItem(FromItem leftFromItem, String itemToken, Set<FromItem> fromItems) {
        int indexOfJoin = itemToken.toUpperCase().indexOf(" JOIN ");
        String firstPart = itemToken.substring(0, indexOfJoin).trim();
        String secondPart = itemToken.substring(indexOfJoin + " JOIN ".length()).trim();
        int indexOfJoinType = firstPart.lastIndexOf(" ");
        String joinTypeString = firstPart.substring(indexOfJoinType).trim().toUpperCase();
        JoinType joinType = JoinType.valueOf(joinTypeString);
        String firstTableToken = firstPart.substring(0, indexOfJoinType).trim();
        int indexOfOn = secondPart.toUpperCase().indexOf(" ON ");
        String secondTableToken = secondPart.substring(0, indexOfOn).trim();
        FromItem leftSide = this.parseTableItem(firstTableToken);
        FromItem rightSide = this.parseTableItem(secondTableToken);
        fromItems.add(leftSide);
        fromItems.add(rightSide);
        String[] onClauses = secondPart.substring(indexOfOn + " ON ".length()).split(" AND ");
        SelectItem[] leftOn = new SelectItem[onClauses.length];
        SelectItem[] rightOn = new SelectItem[onClauses.length];
        for (int i = 0; i < onClauses.length; ++i) {
            String onClause = onClauses[i];
            int indexOfEquals = onClause.indexOf("=");
            String leftPart = onClause.substring(0, indexOfEquals).trim();
            String rightPart = onClause.substring(indexOfEquals + 1).trim();
            leftOn[i] = this.findSelectItem(leftPart, fromItems.toArray(new FromItem[fromItems.size()]));
            rightOn[i] = this.findSelectItem(rightPart, fromItems.toArray(new FromItem[fromItems.size()]));
        }
        FromItem leftItem = leftFromItem != null ? leftFromItem : leftSide;
        FromItem result = new FromItem(joinType, leftItem, rightSide, leftOn, rightOn);
        result.setQuery(this._query);
        return result;
    }

    private SelectItem findSelectItem(String token, FromItem[] joinTables) {
        SelectItemParser selectItemParser = new SelectItemParser(this._query, false);
        SelectItem result = selectItemParser.findSelectItem(token);
        if (result == null) {
            Query temporaryQuery = new Query().from(joinTables);
            selectItemParser = new SelectItemParser(temporaryQuery, false);
            result = selectItemParser.findSelectItem(token);
            if (result == null) {
                throw new QueryParserException("Not capable of parsing ON token: " + token);
            }
            result.setQuery(this._query);
        }
        return result;
    }

    static {
        delimiterMap.put(Character.valueOf('\"'), Character.valueOf('\"'));
        delimiterMap.put(Character.valueOf('['), Character.valueOf(']'));
        logger = LoggerFactory.getLogger(FromItemParser.class);
    }
}

