/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryParameter;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.builder.AbstractQueryFilterBuilder;
import org.apache.metamodel.query.builder.GroupedQueryBuilder;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.query.builder.WhereBuilder;
import org.apache.metamodel.schema.Column;

final class WhereBuilderImpl
extends AbstractQueryFilterBuilder<SatisfiedWhereBuilder<GroupedQueryBuilder>>
implements WhereBuilder<GroupedQueryBuilder>,
SatisfiedWhereBuilder<GroupedQueryBuilder> {
    private final Query _query;
    private final List<FilterItem> _orFilters;
    private FilterItem _parentOrFilter;

    public WhereBuilderImpl(Column column, Query query, GroupedQueryBuilder queryBuilder) {
        this(new SelectItem(column), query, queryBuilder);
    }

    public WhereBuilderImpl(SelectItem selectItem, Query query, GroupedQueryBuilder queryBuilder) {
        super(selectItem, queryBuilder);
        this._query = query;
        this._orFilters = new ArrayList<FilterItem>();
    }

    public WhereBuilderImpl(Column column, Query query, FilterItem parentOrFilter, List<FilterItem> orFilters, GroupedQueryBuilder queryBuilder) {
        super(new SelectItem(column), queryBuilder);
        this._query = query;
        this._parentOrFilter = parentOrFilter;
        this._orFilters = orFilters;
    }

    @Override
    protected SatisfiedWhereBuilder<GroupedQueryBuilder> applyFilter(FilterItem filter) {
        if (this._parentOrFilter == null) {
            this._query.where(filter);
        } else if (this._parentOrFilter.getChildItemCount() == 1) {
            this._query.getWhereClause().removeItem(this._orFilters.get(0));
            this._query.getWhereClause().addItem(this._parentOrFilter);
        }
        this._orFilters.add(filter);
        return this;
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> or(String columnName) {
        Column column = this.findColumn(columnName);
        return this.or(column);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> or(Column column) {
        if (this._parentOrFilter == null) {
            this._parentOrFilter = new FilterItem(this._orFilters);
        }
        return new WhereBuilderImpl(column, this._query, this._parentOrFilter, this._orFilters, this.getQueryBuilder());
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> and(String columnName) {
        Column column = this.findColumn(columnName);
        return this.and(column);
    }

    @Override
    public WhereBuilder<GroupedQueryBuilder> and(Column column) {
        return this.getQueryBuilder().where(column);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> eq(QueryParameter queryParameter) {
        return this.isEquals(queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> isEquals(QueryParameter queryParameter) {
        if (queryParameter == null) {
            throw new IllegalArgumentException("query parameter cannot be null");
        }
        return (SatisfiedWhereBuilder)this._filterBuilder.applyFilter(OperatorType.EQUALS_TO, queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> differentFrom(QueryParameter queryParameter) {
        return this.ne(queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> ne(QueryParameter queryParameter) {
        if (queryParameter == null) {
            throw new IllegalArgumentException("query parameter cannot be null");
        }
        return (SatisfiedWhereBuilder)this._filterBuilder.applyFilter(OperatorType.DIFFERENT_FROM, queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> greaterThan(QueryParameter queryParameter) {
        return this.gt(queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> gt(QueryParameter queryParameter) {
        if (queryParameter == null) {
            throw new IllegalArgumentException("query parameter cannot be null");
        }
        return (SatisfiedWhereBuilder)this._filterBuilder.applyFilter(OperatorType.GREATER_THAN, queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> lessThan(QueryParameter queryParameter) {
        return this.lt(queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> lt(QueryParameter queryParameter) {
        if (queryParameter == null) {
            throw new IllegalArgumentException("query parameter cannot be null");
        }
        return (SatisfiedWhereBuilder)this._filterBuilder.applyFilter(OperatorType.LESS_THAN, queryParameter);
    }

    @Override
    public SatisfiedWhereBuilder<GroupedQueryBuilder> like(QueryParameter queryParameter) {
        if (queryParameter == null) {
            throw new IllegalArgumentException("query parameter cannot be null");
        }
        return (SatisfiedWhereBuilder)this._filterBuilder.applyFilter(OperatorType.LIKE, queryParameter);
    }
}

