/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.JoinType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.JoinFromBuilder;
import org.apache.metamodel.query.builder.JoinFromBuilderImpl;
import org.apache.metamodel.query.builder.SatisfiedFromBuilderCallback;
import org.apache.metamodel.query.builder.TableFromBuilder;
import org.apache.metamodel.schema.Table;

final class TableFromBuilderImpl
extends SatisfiedFromBuilderCallback
implements TableFromBuilder {
    private FromItem fromItem;

    public TableFromBuilderImpl(Table table, Query query, DataContext dataContext) {
        super(query, dataContext);
        this.fromItem = new FromItem(table);
        query.from(this.fromItem);
    }

    @Override
    public JoinFromBuilder innerJoin(String tableName) {
        return this.innerJoin(this.findTable(tableName));
    }

    @Override
    public JoinFromBuilder innerJoin(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new JoinFromBuilderImpl(this.getQuery(), this.fromItem, table, JoinType.INNER, this.getDataContext());
    }

    @Override
    public JoinFromBuilder leftJoin(String tableName) {
        return this.leftJoin(this.findTable(tableName));
    }

    @Override
    public JoinFromBuilder leftJoin(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new JoinFromBuilderImpl(this.getQuery(), this.fromItem, table, JoinType.LEFT, this.getDataContext());
    }

    @Override
    public JoinFromBuilder rightJoin(String tableName) {
        return this.rightJoin(this.findTable(tableName));
    }

    @Override
    public JoinFromBuilder rightJoin(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new JoinFromBuilderImpl(this.getQuery(), this.fromItem, table, JoinType.RIGHT, this.getDataContext());
    }

    @Override
    public TableFromBuilder as(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("alias cannot be null");
        }
        this.fromItem.setAlias(alias);
        return this;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this.fromItem);
    }

    private Table findTable(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        Table table = this.getDataContext().getTableByQualifiedLabel(tableName);
        if (table == null) {
            throw new IllegalArgumentException("No such table: " + tableName);
        }
        return table;
    }
}

