/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.ColumnSelectBuilder;
import org.apache.metamodel.query.builder.ColumnSelectBuilderImpl;
import org.apache.metamodel.query.builder.CountSelectBuilder;
import org.apache.metamodel.query.builder.CountSelectBuilderImpl;
import org.apache.metamodel.query.builder.FunctionSelectBuilder;
import org.apache.metamodel.query.builder.FunctionSelectBuilderImpl;
import org.apache.metamodel.query.builder.GroupedQueryBuilderImpl;
import org.apache.metamodel.query.builder.SatisfiedFromBuilder;
import org.apache.metamodel.query.builder.SatisfiedSelectBuilder;
import org.apache.metamodel.query.builder.SatisfiedSelectBuilderImpl;
import org.apache.metamodel.query.builder.TableFromBuilder;
import org.apache.metamodel.query.builder.TableFromBuilderImpl;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.BaseObject;

abstract class SatisfiedFromBuilderCallback
extends BaseObject
implements SatisfiedFromBuilder {
    private Query query;
    private DataContext dataContext;

    public SatisfiedFromBuilderCallback(Query query, DataContext dataContext) {
        this.query = query;
        this.dataContext = dataContext;
    }

    protected Query getQuery() {
        return this.query;
    }

    protected DataContext getDataContext() {
        return this.dataContext;
    }

    @Override
    public TableFromBuilder and(Table table) {
        if (table == null) {
            throw new IllegalArgumentException("table cannot be null");
        }
        return new TableFromBuilderImpl(table, this.query, this.dataContext);
    }

    @Override
    public ColumnSelectBuilder<?> select(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new ColumnSelectBuilderImpl(column, this.query, queryBuilder);
    }

    @Override
    public SatisfiedSelectBuilder<?> selectAll() {
        this.getQuery().selectAll();
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public FunctionSelectBuilder<?> select(FunctionType function, String columnName) {
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        Column column = queryBuilder.findColumn(columnName);
        return this.select(function, column);
    }

    @Override
    public FunctionSelectBuilder<?> select(FunctionType function, String columnName, Object[] functionParameters) {
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        Column column = queryBuilder.findColumn(columnName);
        return this.select(function, column, functionParameters);
    }

    @Override
    public FunctionSelectBuilder<?> select(FunctionType function, Column column) {
        return this.select(function, column, new Object[0]);
    }

    @Override
    public FunctionSelectBuilder<?> select(FunctionType function, Column column, Object[] functionParameters) {
        if (function == null) {
            throw new IllegalArgumentException("functionType cannot be null");
        }
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new FunctionSelectBuilderImpl(function, column, functionParameters, this.query, queryBuilder);
    }

    @Override
    public CountSelectBuilder<?> selectCount() {
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new CountSelectBuilderImpl(this.query, queryBuilder);
    }

    @Override
    public TableFromBuilder and(String schemaName, String tableName) {
        if (schemaName == null) {
            throw new IllegalArgumentException("schemaName cannot be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        Schema schema = this.dataContext.getSchemaByName(schemaName);
        if (schema == null) {
            schema = this.dataContext.getDefaultSchema();
        }
        return this.and(schema, tableName);
    }

    private TableFromBuilder and(Schema schema, String tableName) {
        Table table = schema.getTableByName(tableName);
        return this.and(table);
    }

    @Override
    public TableFromBuilder and(String tableName) {
        if (tableName == null) {
            throw new IllegalArgumentException("tableName cannot be null");
        }
        return this.and(this.dataContext.getDefaultSchema(), tableName);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(Column ... columns) {
        if (columns == null) {
            throw new IllegalArgumentException("columns cannot be null");
        }
        this.query.select(columns);
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(List<Column> columns) {
        return this.select(columns.toArray(new Column[columns.size()]));
    }

    @Override
    public SatisfiedSelectBuilder<?> select(String ... columnNames) {
        if (columnNames == null) {
            throw new IllegalArgumentException("columnNames cannot be null");
        }
        for (String columnName : columnNames) {
            this.select(columnName);
        }
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(String selectExpression, boolean allowExpressionBasedSelectItem) {
        if (selectExpression == null) {
            throw new IllegalArgumentException("selectExpression cannot be null");
        }
        this.query.select(selectExpression, allowExpressionBasedSelectItem);
        GroupedQueryBuilderImpl queryBuilder = new GroupedQueryBuilderImpl(this.dataContext, this.query);
        return new SatisfiedSelectBuilderImpl(queryBuilder);
    }

    @Override
    public SatisfiedSelectBuilder<?> select(String selectExpression) {
        return this.select(selectExpression, false);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.query);
    }
}

