/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query.builder;

import java.util.Collection;
import java.util.Date;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.builder.FilterBuilder;
import org.apache.metamodel.schema.Column;

public abstract class AbstractFilterBuilder<B>
implements FilterBuilder<B> {
    private final SelectItem _selectItem;

    public AbstractFilterBuilder(SelectItem selectItem) {
        this._selectItem = selectItem;
    }

    protected abstract B applyFilter(FilterItem var1);

    public B applyFilter(OperatorType operator, Object operand) {
        return this.applyFilter(new FilterItem(this._selectItem, operator, operand));
    }

    @Override
    public B in(Collection<?> values) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.IN, values));
    }

    @Override
    public B in(Number ... numbers) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.IN, numbers));
    }

    @Override
    public B in(String ... strings) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.IN, strings));
    }

    @Override
    public B notIn(Collection<?> values) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.NOT_IN, values));
    }

    @Override
    public B notIn(Number ... numbers) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.NOT_IN, numbers));
    }

    @Override
    public B notIn(String ... strings) {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.NOT_IN, strings));
    }

    @Override
    public B isNull() {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, null));
    }

    @Override
    public B isNotNull() {
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, null));
    }

    @Override
    public B isEquals(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, new SelectItem(column)));
    }

    @Override
    public B isEquals(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, date));
    }

    @Override
    public B isEquals(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, number));
    }

    @Override
    public B isEquals(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, string));
    }

    @Override
    public B isEquals(Boolean bool) {
        if (bool == null) {
            throw new IllegalArgumentException("bool cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.EQUALS_TO, bool));
    }

    @Override
    public B isEquals(Object obj) {
        if (obj == null) {
            return this.isNull();
        }
        if (obj instanceof Boolean) {
            return this.isEquals((Boolean)obj);
        }
        if (obj instanceof Number) {
            return this.isEquals((Number)obj);
        }
        if (obj instanceof Date) {
            return this.isEquals((Date)obj);
        }
        if (obj instanceof String) {
            return this.isEquals((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Boolean, Number, Date or String. Found: " + obj);
    }

    @Override
    public B differentFrom(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, new SelectItem(column)));
    }

    @Override
    public B differentFrom(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, date));
    }

    @Override
    public B differentFrom(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, number));
    }

    @Override
    public B differentFrom(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, string));
    }

    @Override
    public B differentFrom(Boolean bool) {
        if (bool == null) {
            throw new IllegalArgumentException("bool cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.DIFFERENT_FROM, bool));
    }

    @Override
    public B differentFrom(Object obj) {
        if (obj == null) {
            return this.isNotNull();
        }
        if (obj instanceof Boolean) {
            return this.differentFrom((Boolean)obj);
        }
        if (obj instanceof Number) {
            return this.differentFrom((Number)obj);
        }
        if (obj instanceof Date) {
            return this.differentFrom((Date)obj);
        }
        if (obj instanceof String) {
            return this.differentFrom((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Boolean, Number, Date or String. Found: " + obj);
    }

    @Override
    public B greaterThan(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN, new SelectItem(column)));
    }

    @Override
    public B greaterThan(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN, date));
    }

    @Override
    public B greaterThan(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN, number));
    }

    @Override
    public B greaterThan(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN, string));
    }

    @Override
    public B lessThan(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN, new SelectItem(column)));
    }

    @Override
    public B lessThan(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN, date));
    }

    @Override
    public B lessThan(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN, number));
    }

    @Override
    public B lessThan(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN, string));
    }

    @Override
    public B lessThan(Object obj) {
        if (obj instanceof Number) {
            return this.lessThan((Number)obj);
        }
        if (obj instanceof Date) {
            return this.lessThan((Date)obj);
        }
        if (obj instanceof String) {
            return this.lessThan((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Number, Date or String. Found: " + obj);
    }

    @Override
    public B greaterThan(Object obj) {
        if (obj instanceof Number) {
            return this.greaterThan((Number)obj);
        }
        if (obj instanceof Date) {
            return this.greaterThan((Date)obj);
        }
        if (obj instanceof String) {
            return this.greaterThan((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Number, Date or String. Found: " + obj);
    }

    @Override
    public B greaterThanOrEquals(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN_OR_EQUAL, new SelectItem(column)));
    }

    @Override
    public B gte(Column column) {
        return this.greaterThanOrEquals(column);
    }

    @Override
    public B greaterThanOrEquals(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN_OR_EQUAL, date));
    }

    @Override
    public B gte(Date date) {
        return this.greaterThanOrEquals(date);
    }

    @Override
    public B greaterThanOrEquals(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN_OR_EQUAL, number));
    }

    @Override
    public B gte(Number number) {
        return this.greaterThanOrEquals(number);
    }

    @Override
    public B greaterThanOrEquals(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.GREATER_THAN_OR_EQUAL, string));
    }

    @Override
    public B gte(String string) {
        return this.greaterThanOrEquals(string);
    }

    @Override
    public B greaterThanOrEquals(Object obj) {
        if (obj instanceof Number) {
            return this.greaterThanOrEquals((Number)obj);
        }
        if (obj instanceof Date) {
            return this.greaterThanOrEquals((Date)obj);
        }
        if (obj instanceof String) {
            return this.greaterThanOrEquals((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Number, Date or String. Found: " + obj);
    }

    @Override
    public B gte(Object obj) {
        return this.greaterThanOrEquals(obj);
    }

    @Override
    public B lessThanOrEquals(Column column) {
        if (column == null) {
            throw new IllegalArgumentException("column cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN_OR_EQUAL, new SelectItem(column)));
    }

    @Override
    public B lte(Column column) {
        return this.lessThanOrEquals(column);
    }

    @Override
    public B lessThanOrEquals(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("date cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN_OR_EQUAL, date));
    }

    @Override
    public B lte(Date date) {
        return this.lessThanOrEquals(date);
    }

    @Override
    public B lessThanOrEquals(Number number) {
        if (number == null) {
            throw new IllegalArgumentException("number cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN_OR_EQUAL, number));
    }

    @Override
    public B lte(Number number) {
        return this.lessThanOrEquals(number);
    }

    @Override
    public B lessThanOrEquals(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LESS_THAN_OR_EQUAL, string));
    }

    @Override
    public B lte(String string) {
        return this.lessThanOrEquals(string);
    }

    @Override
    public B lessThanOrEquals(Object obj) {
        if (obj instanceof Number) {
            return this.lessThanOrEquals((Number)obj);
        }
        if (obj instanceof Date) {
            return this.lessThanOrEquals((Date)obj);
        }
        if (obj instanceof String) {
            return this.lessThanOrEquals((String)obj);
        }
        throw new UnsupportedOperationException("Argument must be a Number, Date or String. Found: " + obj);
    }

    @Override
    public B lte(Object obj) {
        return this.lessThanOrEquals(obj);
    }

    @Override
    public B like(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.LIKE, string));
    }

    @Override
    public B notLike(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        return this.applyFilter(new FilterItem(this._selectItem, OperatorType.NOT_LIKE, string));
    }

    @Override
    public B gt(Column column) {
        return this.greaterThan(column);
    }

    @Override
    public B gt(Date date) {
        return this.greaterThan(date);
    }

    @Override
    public B gt(Number number) {
        return this.greaterThan(number);
    }

    @Override
    public B gt(String string) {
        return this.greaterThan(string);
    }

    @Override
    public B lt(Column column) {
        return this.lessThan(column);
    }

    @Override
    public B lt(Date date) {
        return this.lessThan(date);
    }

    @Override
    public B lt(Number number) {
        return this.lessThan(number);
    }

    @Override
    public B lt(String string) {
        return this.lessThan(string);
    }

    @Override
    public B eq(Boolean bool) {
        return this.isEquals(bool);
    }

    @Override
    public B eq(Column column) {
        return this.isEquals(column);
    }

    @Override
    public B eq(Date date) {
        return this.isEquals(date);
    }

    @Override
    public B eq(Number number) {
        return this.isEquals(number);
    }

    @Override
    public B eq(String string) {
        return this.isEquals(string);
    }

    @Override
    public B eq(Object obj) {
        return this.isEquals(obj);
    }

    @Override
    public B ne(Boolean bool) {
        return this.differentFrom(bool);
    }

    @Override
    public B ne(Column column) {
        return this.differentFrom(column);
    }

    @Override
    public B ne(Date date) {
        return this.differentFrom(date);
    }

    @Override
    public B ne(Number number) {
        return this.differentFrom(number);
    }

    @Override
    public B ne(String string) {
        return this.differentFrom(string);
    }

    @Override
    public B ne(Object obj) {
        return this.differentFrom(obj);
    }

    @Override
    public B lt(Object obj) {
        return this.lessThan(obj);
    }

    @Override
    public B gt(Object obj) {
        return this.greaterThan(obj);
    }
}

