/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.io.Reader;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.DefaultScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.FileHelper;

public class ToStringFunction
extends DefaultScalarFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public ColumnType getExpectedColumnType(ColumnType type) {
        if (type.isLiteral()) {
            return type;
        }
        return ColumnType.STRING;
    }

    @Override
    public String getFunctionName() {
        return "TO_STRING";
    }

    @Override
    public Object evaluate(Row row, Object[] parameters, SelectItem item) {
        Object value = row.getValue(item);
        if (value == null || value instanceof String) {
            return value;
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            try {
                Reader reader = clob.getCharacterStream();
                String result = FileHelper.readAsString(reader);
                return result;
            }
            catch (SQLException e) {
                throw new MetaModelException("Failed to read CLOB to String", e);
            }
        }
        return String.valueOf(value);
    }
}

