/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.DefaultScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.NumberComparator;

public class ToNumberFunction
extends DefaultScalarFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public ColumnType getExpectedColumnType(ColumnType type) {
        if (type.isNumber()) {
            return type;
        }
        return ColumnType.NUMBER;
    }

    @Override
    public String getFunctionName() {
        return "TO_NUMBER";
    }

    @Override
    public Object evaluate(Row row, Object[] parameters, SelectItem item) {
        Object value = row.getValue(item);
        if (value == null || value instanceof Number) {
            return value;
        }
        return NumberComparator.toNumber(value);
    }
}

