/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.util.Date;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.DefaultScalarFunction;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.TimeComparator;

public class ToDateFunction
extends DefaultScalarFunction {
    private static final long serialVersionUID = 1L;

    @Override
    public ColumnType getExpectedColumnType(ColumnType type) {
        if (type.isTimeBased()) {
            return type;
        }
        return ColumnType.TIMESTAMP;
    }

    @Override
    public String getFunctionName() {
        return "TO_DATE";
    }

    @Override
    public Object evaluate(Row row, Object[] parameters, SelectItem item) {
        Object value = row.getValue(item);
        if (value == null || value instanceof Date) {
            return value;
        }
        return TimeComparator.toDate(value);
    }
}

