/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.annotations.InterfaceStability;
import org.apache.metamodel.query.DefaultInvokableQuery;
import org.apache.metamodel.query.FilterClause;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.FromClause;
import org.apache.metamodel.query.FromItem;
import org.apache.metamodel.query.FunctionType;
import org.apache.metamodel.query.GroupByClause;
import org.apache.metamodel.query.GroupByItem;
import org.apache.metamodel.query.InvokableQuery;
import org.apache.metamodel.query.JoinType;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.OrderByClause;
import org.apache.metamodel.query.OrderByItem;
import org.apache.metamodel.query.SelectClause;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.query.parser.QueryParserException;
import org.apache.metamodel.query.parser.QueryPartCollectionProcessor;
import org.apache.metamodel.query.parser.QueryPartParser;
import org.apache.metamodel.query.parser.QueryPartProcessor;
import org.apache.metamodel.query.parser.SelectItemParser;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.BaseObject;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.FormatHelper;
import org.apache.metamodel.util.NumberComparator;

@InterfaceStability.Stable
public final class Query
extends BaseObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5976325207498574216L;
    private final SelectClause _selectClause = new SelectClause(this);
    private final FromClause _fromClause = new FromClause(this);
    private final FilterClause _whereClause = new FilterClause(this, " WHERE ");
    private final GroupByClause _groupByClause = new GroupByClause(this);
    private final FilterClause _havingClause = new FilterClause(this, " HAVING ");
    private final OrderByClause _orderByClause = new OrderByClause(this);
    private Integer _maxRows;
    private Integer _firstRow;

    public Query select(Column column, FromItem fromItem) {
        SelectItem selectItem = new SelectItem(column, fromItem);
        return this.select(selectItem);
    }

    public Query select(List<Column> columns) {
        return this.select(columns.toArray(new Column[columns.size()]));
    }

    public Query select(Column ... columns) {
        for (Column column : columns) {
            SelectItem selectItem = new SelectItem(column);
            selectItem.setQuery(this);
            this._selectClause.addItem(selectItem);
        }
        return this;
    }

    public Query select(SelectItem ... items) {
        this._selectClause.addItems(items);
        return this;
    }

    public Query select(FunctionType functionType, Column column) {
        this._selectClause.addItem(new SelectItem(functionType, column));
        return this;
    }

    public Query select(String expression, String alias) {
        return this.select(new SelectItem(expression, alias));
    }

    public Query select(String expression) {
        return this.select(expression, false);
    }

    public Query select(String expression, boolean allowExpressionBasedSelectItem) {
        QueryPartParser clauseParser = new QueryPartParser(new SelectItemParser(this, allowExpressionBasedSelectItem), expression, ",");
        clauseParser.parse();
        return this;
    }

    private SelectItem findSelectItem(String expression, boolean allowExpressionBasedSelectItem) {
        SelectItemParser parser = new SelectItemParser(this, allowExpressionBasedSelectItem);
        return parser.findSelectItem(expression);
    }

    public Query selectAll() {
        List items = this.getFromClause().getItems();
        for (FromItem fromItem : items) {
            this.selectAll(fromItem);
        }
        return this;
    }

    public Query selectAll(FromItem fromItem) {
        if (fromItem.getTable() != null) {
            List<Column> columns = fromItem.getTable().getColumns();
            for (Column column : columns) {
                this.select(column, fromItem);
            }
        } else if (fromItem.getJoin() != null) {
            this.selectAll(fromItem.getLeftSide());
            this.selectAll(fromItem.getRightSide());
        } else if (fromItem.getSubQuery() != null) {
            List items = fromItem.getSubQuery().getSelectClause().getItems();
            for (SelectItem subQuerySelectItem : items) {
                this.select(new SelectItem(subQuerySelectItem, fromItem));
            }
        } else {
            throw new MetaModelException("All select items ('*') not determinable with from item: " + fromItem);
        }
        return this;
    }

    public Query selectDistinct() {
        this._selectClause.setDistinct(true);
        return this;
    }

    public Query selectCount() {
        return this.select(SelectItem.getCountAllItem());
    }

    public Query from(FromItem ... items) {
        this._fromClause.addItems(items);
        return this;
    }

    public Query from(Table table) {
        return this.from(new FromItem(table));
    }

    public Query from(String expression) {
        return this.from(new FromItem(expression));
    }

    public Query from(Table table, String alias) {
        return this.from(new FromItem(table).setAlias(alias));
    }

    public Query from(Table leftTable, Table rightTable, JoinType joinType, Column leftOnColumn, Column rightOnColumn) {
        SelectItem[] leftOn = new SelectItem[]{new SelectItem(leftOnColumn)};
        SelectItem[] rightOn = new SelectItem[]{new SelectItem(rightOnColumn)};
        FromItem fromItem = new FromItem(joinType, new FromItem(leftTable), new FromItem(rightTable), leftOn, rightOn);
        return this.from(fromItem);
    }

    public Query groupBy(String ... groupByTokens) {
        for (String groupByToken : groupByTokens) {
            SelectItem selectItem = this.findSelectItem(groupByToken, true);
            this.groupBy(new GroupByItem(selectItem));
        }
        return this;
    }

    public Query groupBy(GroupByItem ... items) {
        for (GroupByItem item : items) {
            SelectItem selectItem = item.getSelectItem();
            if (selectItem == null || selectItem.getQuery() != null) continue;
            selectItem.setQuery(this);
        }
        this._groupByClause.addItems(items);
        return this;
    }

    public Query groupBy(Column ... columns) {
        for (Column column : columns) {
            SelectItem selectItem = new SelectItem(column).setQuery(this);
            this._groupByClause.addItem(new GroupByItem(selectItem));
        }
        return this;
    }

    public Query groupBy(List<Column> columns) {
        for (Column column : columns) {
            SelectItem selectItem = new SelectItem(column).setQuery(this);
            this._groupByClause.addItem(new GroupByItem(selectItem));
        }
        return this;
    }

    public Query orderBy(OrderByItem ... items) {
        this._orderByClause.addItems(items);
        return this;
    }

    public Query orderBy(String ... orderByTokens) {
        for (String orderByToken : orderByTokens) {
            OrderByItem.Direction direction;
            if ((orderByToken = orderByToken.trim()).toUpperCase().endsWith("DESC")) {
                direction = OrderByItem.Direction.DESC;
                orderByToken = orderByToken.substring(0, orderByToken.length() - 4).trim();
            } else if (orderByToken.toUpperCase().endsWith("ASC")) {
                direction = OrderByItem.Direction.ASC;
                orderByToken = orderByToken.substring(0, orderByToken.length() - 3).trim();
            } else {
                direction = OrderByItem.Direction.ASC;
            }
            OrderByItem orderByItem = new OrderByItem(this.findSelectItem(orderByToken, true), direction);
            this.orderBy(orderByItem);
        }
        return this;
    }

    public Query orderBy(Column column) {
        return this.orderBy(column, OrderByItem.Direction.ASC);
    }

    public Query orderBy(Column column, OrderByItem.Direction direction) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.orderBy(new OrderByItem(selectItem, direction));
    }

    public Query where(FilterItem ... items) {
        this._whereClause.addItems(items);
        return this;
    }

    public Query where(Iterable<FilterItem> items) {
        this._whereClause.addItems(items);
        return this;
    }

    public Query where(String ... whereItemTokens) {
        for (String whereItemToken : whereItemTokens) {
            FilterItem filterItem = this.findFilterItem(whereItemToken);
            this.where(filterItem);
        }
        return this;
    }

    private FilterItem findFilterItem(String expression) {
        ArrayList operand;
        OperatorType[] operators;
        String upperExpression = expression.toUpperCase();
        QueryPartCollectionProcessor collectionProcessor = new QueryPartCollectionProcessor();
        new QueryPartParser(collectionProcessor, expression, " AND ", " OR ").parse();
        List<String> tokens = collectionProcessor.getTokens();
        List<String> delims = collectionProcessor.getDelims();
        if (tokens.size() != 1) {
            LogicalOperator logicalOperator = LogicalOperator.valueOf(delims.get(1).trim());
            ArrayList<FilterItem> filterItems = new ArrayList<FilterItem>();
            for (int i = 0; i < tokens.size(); ++i) {
                String token = tokens.get(i);
                FilterItem filterItem = this.findFilterItem(token);
                filterItems.add(filterItem);
            }
            return new FilterItem(logicalOperator, filterItems);
        }
        expression = tokens.get(0);
        upperExpression = expression.toUpperCase();
        OperatorType operator = null;
        String leftSide = null;
        String rightSideCandidate = null;
        for (OperatorType operatorCandidate : operators = OperatorType.BUILT_IN_OPERATORS) {
            String searchStr = operatorCandidate.isSpaceDelimited() ? ' ' + operatorCandidate.toSql() + ' ' : operatorCandidate.toSql();
            int operatorIndex = upperExpression.indexOf(searchStr);
            if (operatorIndex <= 0) continue;
            operator = operatorCandidate;
            leftSide = expression.substring(0, operatorIndex).trim();
            rightSideCandidate = expression.substring(operatorIndex + searchStr.length()).trim();
            break;
        }
        if (operator == null) {
            if (expression.endsWith(" IS NOT NULL")) {
                operator = OperatorType.DIFFERENT_FROM;
                leftSide = expression.substring(0, expression.lastIndexOf(" IS NOT NULL")).trim();
                rightSideCandidate = "NULL";
            } else if (expression.endsWith(" IS NULL")) {
                operator = OperatorType.EQUALS_TO;
                leftSide = expression.substring(0, expression.lastIndexOf(" IS NULL")).trim();
                rightSideCandidate = "NULL";
            }
        }
        String rightSide = rightSideCandidate;
        if (operator == null) {
            return new FilterItem(expression);
        }
        final SelectItem selectItem = this.findSelectItem(leftSide, false);
        if (selectItem == null) {
            return new FilterItem(expression);
        }
        if (operator == OperatorType.IN) {
            final ArrayList list = new ArrayList();
            new QueryPartParser(new QueryPartProcessor(){

                @Override
                public void parse(String delim, String itemToken) {
                    Object operand = Query.this.createOperand(itemToken, selectItem, false);
                    list.add(operand);
                }
            }, rightSide, ",").parse();
            operand = list;
        } else {
            operand = this.createOperand(rightSide, selectItem, true);
        }
        return new FilterItem(selectItem, operator, operand);
    }

    private Object createOperand(String token, SelectItem leftSelectItem, boolean searchSelectItems) {
        SelectItem selectItem;
        if (token.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (token.startsWith("'") && token.endsWith("'") && token.length() > 2) {
            String stringOperand = token.substring(1, token.length() - 1);
            stringOperand = stringOperand.replaceAll("\\\\'", "'");
            return stringOperand;
        }
        if (searchSelectItems && (selectItem = this.findSelectItem(token, false)) != null) {
            return selectItem;
        }
        ColumnType expectedColumnType = leftSelectItem.getExpectedColumnType();
        Serializable result = expectedColumnType == null ? NumberComparator.toNumber(token) : (expectedColumnType.isBoolean() ? BooleanComparator.toBoolean(token) : (expectedColumnType.isTimeBased() ? FormatHelper.parseSqlTime(expectedColumnType, token) : NumberComparator.toNumber(token)));
        if (result == null) {
            throw new QueryParserException("Could not parse operand: " + token);
        }
        return result;
    }

    public Query where(SelectItem selectItem, OperatorType operatorType, Object operand) {
        return this.where(new FilterItem(selectItem, operatorType, operand));
    }

    public Query where(Column column, OperatorType operatorType, Object operand) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.where(selectItem, operatorType, operand);
    }

    public Query having(FilterItem ... items) {
        this._havingClause.addItems(items);
        return this;
    }

    public Query having(FunctionType function, Column column, OperatorType operatorType, Object operand) {
        SelectItem selectItem = new SelectItem(function, column);
        return this.having(new FilterItem(selectItem, operatorType, operand));
    }

    public Query having(Column column, OperatorType operatorType, Object operand) {
        SelectItem selectItem = this._selectClause.getSelectItem(column);
        if (selectItem == null) {
            selectItem = new SelectItem(column);
        }
        return this.having(new FilterItem(selectItem, operatorType, operand));
    }

    public Query having(String ... havingItemTokens) {
        for (String havingItemToken : havingItemTokens) {
            FilterItem filterItem = this.findFilterItem(havingItemToken);
            this.having(filterItem);
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    public String toSql() {
        return this.toSql(false);
    }

    protected String toSql(boolean includeSchemaInColumnPaths) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._selectClause.toSql(includeSchemaInColumnPaths));
        sb.append(this._fromClause.toSql(includeSchemaInColumnPaths));
        sb.append(this._whereClause.toSql(includeSchemaInColumnPaths));
        sb.append(this._groupByClause.toSql(includeSchemaInColumnPaths));
        sb.append(this._havingClause.toSql(includeSchemaInColumnPaths));
        sb.append(this._orderByClause.toSql(includeSchemaInColumnPaths));
        return sb.toString();
    }

    public SelectClause getSelectClause() {
        return this._selectClause;
    }

    public FromClause getFromClause() {
        return this._fromClause;
    }

    public FilterClause getWhereClause() {
        return this._whereClause;
    }

    public GroupByClause getGroupByClause() {
        return this._groupByClause;
    }

    public FilterClause getHavingClause() {
        return this._havingClause;
    }

    public OrderByClause getOrderByClause() {
        return this._orderByClause;
    }

    public Query setMaxRows(Integer maxRows) {
        int maxRowsValue;
        if (maxRows != null && (maxRowsValue = maxRows.intValue()) < 0) {
            throw new IllegalArgumentException("Max rows cannot be negative");
        }
        this._maxRows = maxRows;
        return this;
    }

    public Integer getMaxRows() {
        return this._maxRows;
    }

    public Query setFirstRow(Integer firstRow) {
        if (firstRow != null && firstRow < 1) {
            throw new IllegalArgumentException("First row cannot be negative or zero");
        }
        this._firstRow = firstRow;
        return this;
    }

    public Integer getFirstRow() {
        return this._firstRow;
    }

    public InvokableQuery invokable(DataContext dataContext) {
        return new DefaultInvokableQuery(this, dataContext);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._maxRows);
        identifiers.add(this._selectClause);
        identifiers.add(this._fromClause);
        identifiers.add(this._whereClause);
        identifiers.add(this._groupByClause);
        identifiers.add(this._havingClause);
        identifiers.add(this._orderByClause);
    }

    public Query clone() {
        Query q = new Query();
        q.setMaxRows(this._maxRows);
        q.setFirstRow(this._firstRow);
        q.getSelectClause().setDistinct(this._selectClause.isDistinct());
        for (BaseObject item : this._fromClause.getItems()) {
            q.from(((FromItem)item).clone());
        }
        for (BaseObject item : this._selectClause.getItems()) {
            q.select(((SelectItem)item).clone(q));
        }
        for (BaseObject item : this._whereClause.getItems()) {
            q.where(((FilterItem)item).clone());
        }
        for (BaseObject item : this._groupByClause.getItems()) {
            q.groupBy(((GroupByItem)item).clone());
        }
        for (BaseObject item : this._havingClause.getItems()) {
            q.having(((FilterItem)item).clone());
        }
        for (BaseObject item : this._orderByClause.getItems()) {
            q.orderBy(((OrderByItem)item).clone());
        }
        return q;
    }
}

