/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.metamodel.data.IRowFilter;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.OperatorType;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.QueryItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.BaseObject;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.FormatHelper;
import org.apache.metamodel.util.ObjectComparator;
import org.apache.metamodel.util.WildcardPattern;

public class FilterItem
extends BaseObject
implements QueryItem,
Cloneable,
IRowFilter {
    private static final long serialVersionUID = 2435322742894653227L;
    private Query _query;
    private final SelectItem _selectItem;
    private final OperatorType _operator;
    private final Object _operand;
    private final List<FilterItem> _childItems;
    private final LogicalOperator _logicalOperator;
    private final String _expression;
    private transient Set<?> _inValues;

    private FilterItem(SelectItem selectItem, OperatorType operator, Object operand, List<FilterItem> orItems, String expression, LogicalOperator logicalOperator) {
        this._selectItem = selectItem;
        this._operator = operator;
        this._operand = this.validateOperand(operand);
        this._childItems = orItems;
        this._expression = expression;
        this._logicalOperator = logicalOperator;
    }

    private Object validateOperand(Object operand) {
        if (operand instanceof Column) {
            operand = new SelectItem((Column)operand);
        }
        return operand;
    }

    public FilterItem(SelectItem selectItem, OperatorType operator, Object operand) throws IllegalArgumentException {
        this(selectItem, operator, operand, null, null, null);
        ColumnType type;
        if (this._operand == null) {
            this.require("Can only use EQUALS or DIFFERENT_FROM operator with null-operand", this._operator == OperatorType.DIFFERENT_FROM || this._operator == OperatorType.EQUALS_TO);
        }
        if ((this._operator == OperatorType.LIKE || this._operator == OperatorType.NOT_LIKE) && (type = this._selectItem.getColumn().getType()) != null) {
            this.require("Can only use LIKE operator with strings", type.isLiteral() && (this._operand instanceof String || this._operand instanceof SelectItem));
        }
        this.require("SelectItem cannot be null", this._selectItem != null);
    }

    public FilterItem(String expression) {
        this(null, null, null, null, expression, null);
        this.require("Expression cannot be null", this._expression != null);
    }

    public FilterItem(List<FilterItem> items) {
        this(LogicalOperator.OR, items);
    }

    public FilterItem(LogicalOperator logicalOperator, List<FilterItem> items) {
        this(null, null, null, items, null, logicalOperator);
        this.require("Child items cannot be null", this._childItems != null);
        this.require("Child items cannot be empty", !this._childItems.isEmpty());
    }

    public FilterItem(LogicalOperator logicalOperator, FilterItem ... items) {
        this(logicalOperator, Arrays.asList(items));
    }

    public FilterItem(FilterItem ... items) {
        this(Arrays.asList(items));
    }

    private void require(String errorMessage, boolean b) {
        if (!b) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public SelectItem getSelectItem() {
        return this._selectItem;
    }

    public OperatorType getOperator() {
        return this._operator;
    }

    public Object getOperand() {
        return this._operand;
    }

    public String getExpression() {
        return this._expression;
    }

    @Override
    public Query getQuery() {
        return this._query;
    }

    public LogicalOperator getLogicalOperator() {
        return this._logicalOperator;
    }

    @Override
    public FilterItem setQuery(Query query) {
        block3: {
            block2: {
                SelectItem operand;
                this._query = query;
                if (this._childItems != null) break block2;
                if (this._expression != null) break block3;
                if (this._selectItem.getQuery() == null) {
                    this._selectItem.setQuery(this._query);
                }
                if (!(this._operand instanceof SelectItem) || (operand = (SelectItem)this._operand).getQuery() != null) break block3;
                operand.setQuery(this._query);
                break block3;
            }
            for (FilterItem item : this._childItems) {
                if (item.getQuery() != null) continue;
                item.setQuery(this._query);
            }
        }
        return this;
    }

    @Override
    public String toSql() {
        return this.toSql(false);
    }

    @Override
    public String toSql(boolean includeSchemaInColumnPaths) {
        if (this._expression != null) {
            return this._expression;
        }
        StringBuilder sb = new StringBuilder();
        if (this._childItems == null) {
            sb.append(this._selectItem.getSameQueryAlias(includeSchemaInColumnPaths));
            if (this._operand == null && this._operator == OperatorType.EQUALS_TO) {
                sb.append(" IS NULL");
            } else if (this._operand == null && this._operator == OperatorType.DIFFERENT_FROM) {
                sb.append(" IS NOT NULL");
            } else {
                Object operand = FilterItem.appendOperator(sb, this._operand, this._operator);
                if (operand instanceof SelectItem) {
                    String selectItemString = ((SelectItem)operand).getSameQueryAlias(includeSchemaInColumnPaths);
                    sb.append(selectItemString);
                } else {
                    ColumnType columnType = this._selectItem.getExpectedColumnType();
                    String sqlValue = FormatHelper.formatSqlValue(columnType, operand);
                    sb.append(sqlValue);
                }
            }
        } else {
            sb.append('(');
            for (int i = 0; i < this._childItems.size(); ++i) {
                FilterItem item = this._childItems.get(i);
                if (i != 0) {
                    sb.append(' ');
                    sb.append(this._logicalOperator.toString());
                    sb.append(' ');
                }
                sb.append(item.toSql());
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static Object appendOperator(StringBuilder sb, Object operand, OperatorType operator) {
        sb.append(' ');
        sb.append(operator.toSql());
        sb.append(' ');
        if (operator == OperatorType.IN || operator == OperatorType.NOT_IN) {
            operand = CollectionUtils.toList(operand);
        }
        return operand;
    }

    public boolean evaluate(Row row) {
        this.require("Expression-based filters cannot be manually evaluated", this._expression == null);
        if (this._childItems == null) {
            Object selectItemValue = row.getValue(this._selectItem);
            Object operandValue = this._operand;
            if (this._operand instanceof SelectItem) {
                SelectItem selectItem = (SelectItem)this._operand;
                operandValue = row.getValue(selectItem);
            }
            if (operandValue == null) {
                if (this._operator == OperatorType.DIFFERENT_FROM) {
                    return selectItemValue != null;
                }
                if (this._operator == OperatorType.EQUALS_TO) {
                    return selectItemValue == null;
                }
                return false;
            }
            if (selectItemValue == null) {
                return this._operator == OperatorType.DIFFERENT_FROM;
            }
            return this.compare(selectItemValue, operandValue);
        }
        if (this._logicalOperator == LogicalOperator.AND) {
            for (FilterItem item : this._childItems) {
                boolean result = item.evaluate(row);
                if (result) continue;
                return false;
            }
            return true;
        }
        for (FilterItem item : this._childItems) {
            boolean result = item.evaluate(row);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean compare(Object selectItemValue, Object operandValue) {
        Comparator<Object> comparator = ObjectComparator.getComparator();
        if (this._operator == OperatorType.DIFFERENT_FROM) {
            return comparator.compare(selectItemValue, operandValue) != 0;
        }
        if (this._operator == OperatorType.EQUALS_TO) {
            return comparator.compare(selectItemValue, operandValue) == 0;
        }
        if (this._operator == OperatorType.GREATER_THAN) {
            return comparator.compare(selectItemValue, operandValue) > 0;
        }
        if (this._operator == OperatorType.GREATER_THAN_OR_EQUAL) {
            return comparator.compare(selectItemValue, operandValue) >= 0;
        }
        if (this._operator == OperatorType.LESS_THAN) {
            return comparator.compare(selectItemValue, operandValue) < 0;
        }
        if (this._operator == OperatorType.LESS_THAN_OR_EQUAL) {
            return comparator.compare(selectItemValue, operandValue) <= 0;
        }
        if (this._operator == OperatorType.LIKE) {
            WildcardPattern matcher = new WildcardPattern((String)operandValue, '%');
            return matcher.matches((String)selectItemValue);
        }
        if (this._operator == OperatorType.NOT_LIKE) {
            WildcardPattern matcher = new WildcardPattern((String)operandValue, '%');
            return !matcher.matches((String)selectItemValue);
        }
        if (this._operator == OperatorType.IN) {
            Set<?> inValues = this.getInValues();
            return inValues.contains(selectItemValue);
        }
        if (this._operator == OperatorType.NOT_IN) {
            Set<?> inValues = this.getInValues();
            return !inValues.contains(selectItemValue);
        }
        throw new IllegalStateException("Operator could not be determined");
    }

    private Set<?> getInValues() {
        if (this._inValues == null) {
            if (this._operand instanceof Set) {
                this._inValues = (Set)this._operand;
            } else {
                List<?> list = CollectionUtils.toList(this._operand);
                this._inValues = new HashSet(list);
            }
        }
        return this._inValues;
    }

    protected FilterItem clone() {
        ArrayList<FilterItem> orItems = this._childItems == null ? null : new ArrayList<FilterItem>(this._childItems);
        Object operand = this._operand instanceof SelectItem ? ((SelectItem)this._operand).clone() : this._operand;
        SelectItem selectItem = this._selectItem == null ? null : this._selectItem.clone();
        return new FilterItem(selectItem, this._operator, operand, orItems, this._expression, this._logicalOperator);
    }

    public boolean isReferenced(Column column) {
        if (column != null) {
            if (this._selectItem != null && this._selectItem.isReferenced(column)) {
                return true;
            }
            if (this._operand != null && this._operand instanceof SelectItem && ((SelectItem)this._operand).isReferenced(column)) {
                return true;
            }
            if (this._childItems != null) {
                for (FilterItem item : this._childItems) {
                    if (!item.isReferenced(column)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._expression);
        identifiers.add(this._operand);
        identifiers.add(this._childItems);
        identifiers.add(this._operator);
        identifiers.add(this._selectItem);
        identifiers.add((Object)this._logicalOperator);
    }

    public int getChildItemCount() {
        if (this._childItems == null) {
            return 0;
        }
        return this._childItems.size();
    }

    public FilterItem[] getChildItems() {
        if (this._childItems == null) {
            return null;
        }
        return this._childItems.toArray(new FilterItem[this._childItems.size()]);
    }

    public boolean isCompoundFilter() {
        return this._childItems != null;
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public boolean accept(Row row) {
        return this.evaluate(row);
    }
}

