/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.intercept;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.create.TableCreationBuilder;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.drop.TableDropBuilder;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.intercept.DataSetInterceptor;
import org.apache.metamodel.intercept.InterceptableUpdateScript;
import org.apache.metamodel.intercept.InterceptorList;
import org.apache.metamodel.intercept.QueryInterceptor;
import org.apache.metamodel.intercept.RowDeletionInterceptor;
import org.apache.metamodel.intercept.RowInsertionInterceptor;
import org.apache.metamodel.intercept.RowUpdationInterceptor;
import org.apache.metamodel.intercept.SchemaInterceptor;
import org.apache.metamodel.intercept.TableCreationInterceptor;
import org.apache.metamodel.intercept.TableDropInterceptor;
import org.apache.metamodel.query.CompiledQuery;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.builder.InitFromBuilder;
import org.apache.metamodel.query.builder.InitFromBuilderImpl;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.update.RowUpdationBuilder;

public class InterceptableDataContext
implements UpdateableDataContext {
    private final DataContext _delegate;
    private final InterceptorList<DataSet> _dataSetInterceptors;
    private final InterceptorList<Query> _queryInterceptors;
    private final InterceptorList<Schema> _schemaInterceptors;
    private final InterceptorList<RowInsertionBuilder> _rowInsertionInterceptors;
    private final InterceptorList<RowUpdationBuilder> _rowUpdationInterceptors;
    private final InterceptorList<RowDeletionBuilder> _rowDeletionInterceptors;
    private final InterceptorList<TableCreationBuilder> _tableCreationInterceptors;
    private final InterceptorList<TableDropBuilder> _tableDropInterceptors;

    protected InterceptableDataContext(DataContext delegate) {
        this._delegate = delegate;
        this._dataSetInterceptors = new InterceptorList();
        this._queryInterceptors = new InterceptorList();
        this._schemaInterceptors = new InterceptorList();
        this._rowInsertionInterceptors = new InterceptorList();
        this._rowUpdationInterceptors = new InterceptorList();
        this._rowDeletionInterceptors = new InterceptorList();
        this._tableCreationInterceptors = new InterceptorList();
        this._tableDropInterceptors = new InterceptorList();
    }

    public InterceptableDataContext addTableCreationInterceptor(TableCreationInterceptor interceptor) {
        this._tableCreationInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeTableCreationInterceptor(TableCreationInterceptor interceptor) {
        this._tableCreationInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addTableDropInterceptor(TableDropInterceptor interceptor) {
        this._tableDropInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeTableDropInterceptor(TableDropInterceptor interceptor) {
        this._tableDropInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowInsertionInterceptor(RowInsertionInterceptor interceptor) {
        this._rowInsertionInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowInsertionInterceptor(RowInsertionInterceptor interceptor) {
        this._rowInsertionInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowUpdationInterceptor(RowUpdationInterceptor interceptor) {
        this._rowUpdationInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowUpdationInterceptor(RowUpdationInterceptor interceptor) {
        this._rowUpdationInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addRowDeletionInterceptor(RowDeletionInterceptor interceptor) {
        this._rowDeletionInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeRowDeletionInterceptor(RowDeletionInterceptor interceptor) {
        this._rowDeletionInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addQueryInterceptor(QueryInterceptor interceptor) {
        this._queryInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeQueryInterceptor(QueryInterceptor interceptor) {
        this._queryInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addSchemaInterceptor(SchemaInterceptor interceptor) {
        this._schemaInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeSchemaInterceptor(SchemaInterceptor interceptor) {
        this._schemaInterceptors.remove(interceptor);
        return this;
    }

    public InterceptableDataContext addDataSetInterceptor(DataSetInterceptor interceptor) {
        this._dataSetInterceptors.add(interceptor);
        return this;
    }

    public InterceptableDataContext removeDataSetInterceptor(DataSetInterceptor interceptor) {
        this._dataSetInterceptors.remove(interceptor);
        return this;
    }

    public InterceptorList<DataSet> getDataSetInterceptors() {
        return this._dataSetInterceptors;
    }

    public InterceptorList<Query> getQueryInterceptors() {
        return this._queryInterceptors;
    }

    public InterceptorList<RowInsertionBuilder> getRowInsertionInterceptors() {
        return this._rowInsertionInterceptors;
    }

    public InterceptorList<RowUpdationBuilder> getRowUpdationInterceptors() {
        return this._rowUpdationInterceptors;
    }

    public InterceptorList<RowDeletionBuilder> getRowDeletionInterceptors() {
        return this._rowDeletionInterceptors;
    }

    public InterceptorList<Schema> getSchemaInterceptors() {
        return this._schemaInterceptors;
    }

    public InterceptorList<TableCreationBuilder> getTableCreationInterceptors() {
        return this._tableCreationInterceptors;
    }

    public DataContext getDelegate() {
        return this._delegate;
    }

    @Override
    public DataSet executeQuery(Query query) throws MetaModelException {
        query = this._queryInterceptors.interceptAll(query);
        DataSet dataSet = this._delegate.executeQuery(query);
        dataSet = this._dataSetInterceptors.interceptAll(dataSet);
        return dataSet;
    }

    @Override
    public UpdateableDataContext refreshSchemas() {
        this._delegate.refreshSchemas();
        return this;
    }

    @Override
    public List<Schema> getSchemas() throws MetaModelException {
        return this._delegate.getSchemas().stream().map(schema -> {
            if (this._schemaInterceptors.isEmpty()) {
                return schema;
            }
            return this._schemaInterceptors.interceptAll((Schema)schema);
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getSchemaNames() throws MetaModelException {
        if (this._schemaInterceptors.isEmpty()) {
            return this._delegate.getSchemaNames();
        }
        return this.getSchemas().stream().map(schema -> schema.getName()).collect(Collectors.toList());
    }

    @Override
    public Schema getDefaultSchema() throws MetaModelException {
        Schema schema = this._delegate.getDefaultSchema();
        schema = this._schemaInterceptors.interceptAll(schema);
        return schema;
    }

    @Override
    public Schema getSchemaByName(String name) throws MetaModelException {
        Schema schema = this._delegate.getSchemaByName(name);
        schema = this._schemaInterceptors.interceptAll(schema);
        return schema;
    }

    @Override
    public InitFromBuilder query() {
        return new InitFromBuilderImpl(this);
    }

    @Override
    public Column getColumnByQualifiedLabel(String columnName) {
        return this._delegate.getColumnByQualifiedLabel(columnName);
    }

    @Override
    public Table getTableByQualifiedLabel(String tableName) {
        return this._delegate.getTableByQualifiedLabel(tableName);
    }

    @Override
    public UpdateSummary executeUpdate(UpdateScript update) {
        if (!(this._delegate instanceof UpdateableDataContext)) {
            throw new UnsupportedOperationException("Delegate is not an UpdateableDataContext");
        }
        UpdateableDataContext delegate = (UpdateableDataContext)this._delegate;
        if (this._tableCreationInterceptors.isEmpty() && this._tableDropInterceptors.isEmpty() && this._rowInsertionInterceptors.isEmpty() && this._rowUpdationInterceptors.isEmpty() && this._rowDeletionInterceptors.isEmpty()) {
            return delegate.executeUpdate(update);
        }
        InterceptableUpdateScript interceptableUpdateScript = new InterceptableUpdateScript(this, update, this._tableCreationInterceptors, this._tableDropInterceptors, this._rowInsertionInterceptors, this._rowUpdationInterceptors, this._rowDeletionInterceptors);
        return delegate.executeUpdate(interceptableUpdateScript);
    }

    @Override
    public Query parseQuery(String queryString) throws MetaModelException {
        return this._delegate.parseQuery(queryString);
    }

    @Override
    public DataSet executeQuery(String queryString) throws MetaModelException {
        Query query = this.parseQuery(queryString);
        DataSet dataSet = this.executeQuery(query);
        return dataSet;
    }

    @Override
    public CompiledQuery compileQuery(Query query) {
        return this._delegate.compileQuery(query);
    }

    @Override
    public DataSet executeQuery(CompiledQuery compiledQuery, Object ... values) {
        return this._delegate.executeQuery(compiledQuery, values);
    }
}

