/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.insert;

import java.util.List;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.data.AbstractRowBuilder;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

public abstract class AbstractRowInsertionBuilder<U extends UpdateCallback>
extends AbstractRowBuilder<RowInsertionBuilder>
implements RowInsertionBuilder {
    private final U _updateCallback;
    private final Table _table;

    public AbstractRowInsertionBuilder(U updateCallback, Table table) {
        super(table);
        this._updateCallback = updateCallback;
        this._table = table;
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    protected U getUpdateCallback() {
        return this._updateCallback;
    }

    @Override
    public RowInsertionBuilder like(Row row) {
        List<SelectItem> selectItems = row.getSelectItems();
        for (int i = 0; i < selectItems.size(); ++i) {
            SelectItem selectItem = selectItems.get(i);
            Column column = selectItem.getColumn();
            if (column == null) continue;
            if (this._table == column.getTable()) {
                this.value(column, row.getValue(i));
                continue;
            }
            this.value(column.getName(), row.getValue(i));
        }
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(this._table.getQualifiedLabel());
        sb.append("(");
        Column[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(columns[i].getName());
        }
        sb.append(") VALUES (");
        Object[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            Object value;
            if (i != 0) {
                sb.append(',');
            }
            String stringValue = (value = values[i]) == null ? "NULL" : (value instanceof String ? "\"" + value + "\"" : value.toString());
            sb.append(stringValue);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

