/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.factory;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceProperties;
import org.apache.metamodel.factory.ResourcePropertiesImpl;
import org.apache.metamodel.factory.SimpleResourceProperties;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.NumberComparator;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.util.SimpleTableDefParser;

public class DataContextPropertiesImpl
implements DataContextProperties {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_USERNAME = "username";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String PROPERTY_DRIVER_CLASS = "driver-class";
    public static final String PROPERTY_HOSTNAME = "hostname";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_DATABASE = "database";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_CATALOG_NAME = "catalog";
    public static final String PROPERTY_RESOURCE_PROPERTIES = "resource";
    public static final String PROPERTY_IS_MULTILINE_VALUES_ENABLED = "multiline-values";
    public static final String PROPERTY_IS_FAIL_ON_INCONSISTENT_ROW_LENGTH = "fail-on-inconsistent-row-length";
    public static final String PROPERTY_ESCAPE_CHAR = "escape-char";
    public static final String PROPERTY_QUOTE_CHAR = "quote-char";
    public static final String PROPERTY_SEPARATOR_CHAR = "separator-char";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_SKIP_EMPTY_COLUMNS = "skip-empty-columns";
    public static final String PROPERTY_SKIP_EMPTY_LINES = "skip-empty-lines";
    public static final String PROPERTY_COLUMN_NAME_LINE_NUMBER = "column-name-line-number";
    public static final String PROPERTY_DATA_CONTEXT_TYPE = "type";
    public static final String PROPERTY_TABLE_TYPES = "table-types";
    public static final String PROPERTY_DATA_SOURCE = "data-source";
    public static final String PROPERTY_TABLE_DEFS = "table-defs";
    private final Map<String, Object> map;

    public DataContextPropertiesImpl() {
        this(new HashMap<String, Object>());
    }

    public DataContextPropertiesImpl(Properties properties) {
        this();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String key : propertyNames) {
            this.put(key, properties.get(key));
        }
    }

    public DataContextPropertiesImpl(Map<String, Object> map) {
        this.map = map;
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    public String getString(String key) {
        Object value = this.map.get(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public Character getChar(String key) {
        String str = this.getString(key);
        if (str == null || str.isEmpty()) {
            return null;
        }
        return Character.valueOf(str.charAt(0));
    }

    public Integer getInt(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        return NumberComparator.toNumber(obj).intValue();
    }

    private Boolean getBoolean(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        return BooleanComparator.toBoolean(obj);
    }

    public Map<String, Object> getMap(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        if (obj instanceof String) {
            // empty if block
        }
        throw new IllegalStateException("Expected Map value for property '" + key + "'. Found " + obj.getClass().getName());
    }

    @Override
    public String getDataContextType() {
        return this.getString(PROPERTY_DATA_CONTEXT_TYPE);
    }

    public void setDataContextType(String type) {
        this.put(PROPERTY_DATA_CONTEXT_TYPE, type);
    }

    @Override
    public Map<String, Object> toMap() {
        return this.map;
    }

    @Override
    public ResourceProperties getResourceProperties() {
        Object resourceValue = this.get(PROPERTY_RESOURCE_PROPERTIES);
        if (resourceValue == null) {
            return null;
        }
        if (resourceValue instanceof String) {
            return new SimpleResourceProperties((String)resourceValue);
        }
        if (resourceValue instanceof URI) {
            return new SimpleResourceProperties((URI)resourceValue);
        }
        if (resourceValue instanceof Map) {
            Map resourceMap = (Map)resourceValue;
            return new ResourcePropertiesImpl(resourceMap);
        }
        throw new IllegalStateException("Expected String, URI or Map value for property 'resource'. Found: " + resourceValue);
    }

    @Override
    public Integer getColumnNameLineNumber() {
        return this.getInt(PROPERTY_COLUMN_NAME_LINE_NUMBER);
    }

    @Override
    public Boolean isSkipEmptyLines() {
        return this.getBoolean(PROPERTY_SKIP_EMPTY_LINES);
    }

    @Override
    public Boolean isSkipEmptyColumns() {
        return this.getBoolean(PROPERTY_SKIP_EMPTY_COLUMNS);
    }

    @Override
    public String getEncoding() {
        return this.getString(PROPERTY_ENCODING);
    }

    @Override
    public Character getSeparatorChar() {
        return this.getChar(PROPERTY_SEPARATOR_CHAR);
    }

    @Override
    public Character getQuoteChar() {
        return this.getChar(PROPERTY_QUOTE_CHAR);
    }

    @Override
    public Character getEscapeChar() {
        return this.getChar(PROPERTY_ESCAPE_CHAR);
    }

    @Override
    public Boolean isFailOnInconsistentRowLength() {
        return this.getBoolean(PROPERTY_IS_FAIL_ON_INCONSISTENT_ROW_LENGTH);
    }

    @Override
    public Boolean isMultilineValuesEnabled() {
        return this.getBoolean(PROPERTY_IS_MULTILINE_VALUES_ENABLED);
    }

    @Override
    public TableType[] getTableTypes() {
        Object obj = this.get(PROPERTY_TABLE_TYPES);
        if (obj == null) {
            return null;
        }
        if (obj instanceof TableType[]) {
            return (TableType[])obj;
        }
        if (obj instanceof TableType) {
            return new TableType[]{(TableType)((Object)obj)};
        }
        if (obj instanceof String) {
            String str = (String)obj;
            if (str.startsWith("[") && str.endsWith("]")) {
                str = str.substring(1, str.length() - 2);
            }
            String[] tokens = str.split(",");
            TableType[] tableTypes = new TableType[tokens.length];
            for (int i = 0; i < tableTypes.length; ++i) {
                tableTypes[i] = TableType.getTableType(tokens[i]);
            }
        }
        throw new IllegalStateException("Expected TableType[] value for property 'table-types'. Found " + obj.getClass().getName());
    }

    @Override
    public String getCatalogName() {
        return this.getString(PROPERTY_CATALOG_NAME);
    }

    @Override
    public String getUrl() {
        return this.getString(PROPERTY_URL);
    }

    @Override
    public DataSource getDataSource() {
        return (DataSource)this.get(PROPERTY_DATA_SOURCE);
    }

    @Override
    public String getUsername() {
        return this.getString(PROPERTY_USERNAME);
    }

    @Override
    public String getPassword() {
        return this.getString(PROPERTY_PASSWORD);
    }

    @Override
    public String getDriverClassName() {
        return this.getString(PROPERTY_DRIVER_CLASS);
    }

    @Override
    public String getHostname() {
        return this.getString(PROPERTY_HOSTNAME);
    }

    @Override
    public Integer getPort() {
        return this.getInt(PROPERTY_PORT);
    }

    @Override
    public String getDatabaseName() {
        return this.getString(PROPERTY_DATABASE);
    }

    @Override
    public SimpleTableDef[] getTableDefs() {
        Object obj = this.get(PROPERTY_TABLE_DEFS);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SimpleTableDef[]) {
            return (SimpleTableDef[])obj;
        }
        if (obj instanceof SimpleTableDef) {
            return new SimpleTableDef[]{(SimpleTableDef)obj};
        }
        if (obj instanceof String) {
            return SimpleTableDefParser.parseTableDefs((String)obj);
        }
        throw new IllegalStateException("Expected SimpleTableDef[] value for property 'table-defs'. Found " + obj.getClass().getName());
    }
}

