/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextFactoryRegistry;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.ResourceFactoryRegistryImpl;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;

public class DataContextFactoryRegistryImpl
implements DataContextFactoryRegistry,
Cloneable {
    private static final DataContextFactoryRegistry DEFAULT_INSTANCE = DataContextFactoryRegistryImpl.createFromClasspath();
    private final List<DataContextFactory> factories;
    private final ResourceFactoryRegistry resourceFactoryRegistry;

    public static DataContextFactoryRegistry createFromClasspath() {
        ResourceFactoryRegistry resourceFactoryRegistry = ResourceFactoryRegistryImpl.getDefaultInstance();
        DataContextFactoryRegistryImpl registry = new DataContextFactoryRegistryImpl(resourceFactoryRegistry);
        registry.discoverFromClasspath();
        return registry;
    }

    public static DataContextFactoryRegistry getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public DataContextFactoryRegistryImpl(ResourceFactoryRegistry resourceFactoryRegistry) {
        this.factories = new ArrayList<DataContextFactory>();
        this.resourceFactoryRegistry = resourceFactoryRegistry;
    }

    public DataContextFactoryRegistryImpl(Collection<DataContextFactory> factories, ResourceFactoryRegistry resourceFactoryRegistry) {
        this.factories = new ArrayList<DataContextFactory>(factories);
        this.resourceFactoryRegistry = resourceFactoryRegistry;
    }

    public DataContextFactoryRegistryImpl clone() {
        return new DataContextFactoryRegistryImpl(this.factories, this.resourceFactoryRegistry);
    }

    @Override
    public void addFactory(DataContextFactory factory) {
        this.factories.add(factory);
    }

    @Override
    public void clearFactories() {
        this.factories.clear();
    }

    @Override
    public Collection<DataContextFactory> getFactories() {
        return Collections.unmodifiableList(this.factories);
    }

    @Override
    public DataContext createDataContext(DataContextProperties properties) throws UnsupportedDataContextPropertiesException {
        for (DataContextFactory factory : this.factories) {
            if (!factory.accepts(properties, this.resourceFactoryRegistry)) continue;
            return factory.create(properties, this.resourceFactoryRegistry);
        }
        throw new UnsupportedDataContextPropertiesException();
    }

    public void discoverFromClasspath() {
        ServiceLoader<DataContextFactory> serviceLoader = ServiceLoader.load(DataContextFactory.class);
        for (DataContextFactory factory : serviceLoader) {
            this.addFactory(factory);
        }
    }
}

