/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.factory;

import java.util.Collection;
import java.util.Map;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.NumberComparator;

public abstract class AbstractDataContextFactory
implements DataContextFactory {
    protected abstract String getType();

    @Override
    public final boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        return this.getType().equals(properties.getDataContextType());
    }

    protected String getString(Object value, String ifNull) {
        if (AbstractDataContextFactory.isNullOrEmpty(value)) {
            return ifNull;
        }
        return value.toString();
    }

    protected int getInt(Object value, int ifNull) {
        if (AbstractDataContextFactory.isNullOrEmpty(value)) {
            return ifNull;
        }
        return NumberComparator.toNumber(value).intValue();
    }

    protected boolean getBoolean(Object value, boolean ifNull) {
        if (AbstractDataContextFactory.isNullOrEmpty(value)) {
            return ifNull;
        }
        return BooleanComparator.toBoolean(value);
    }

    protected char getChar(Object value, char ifNull) {
        if (AbstractDataContextFactory.isNullOrEmpty(value)) {
            return ifNull;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return value.toString().charAt(0);
    }

    private static boolean isNullOrEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).isEmpty()) {
            return true;
        }
        if (value instanceof Collection && ((Collection)value).isEmpty()) {
            return true;
        }
        return value instanceof Map && ((Map)value).isEmpty();
    }
}

