/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.WrappingDataSet;
import org.apache.metamodel.query.InvokableQuery;
import org.apache.metamodel.util.ImmutableRef;

public class UnionDataSet
extends AbstractDataSet
implements WrappingDataSet {
    private final Iterable<Supplier<DataSet>> _dataSetProviders;
    private Iterator<Supplier<DataSet>> _iterator;
    private DataSet _currentDataSet;

    public static DataSet ofQueries(DataSetHeader header, Collection<InvokableQuery> queries) {
        Function<InvokableQuery, Supplier> mapper = q -> () -> q.execute();
        return new UnionDataSet(header, queries.stream().map(mapper).collect(Collectors.toList()));
    }

    public static DataSet ofDataSets(DataSetHeader header, Collection<DataSet> dataSets) {
        return new UnionDataSet(header, dataSets.stream().map(ds -> ImmutableRef.of(ds)).collect(Collectors.toList()));
    }

    private UnionDataSet(DataSetHeader header, Iterable<Supplier<DataSet>> dataSetProviders) {
        super(header);
        this._dataSetProviders = Objects.requireNonNull(dataSetProviders);
    }

    @Override
    public boolean next() {
        if (this._iterator == null) {
            this._iterator = this._dataSetProviders.iterator();
        }
        while (this._currentDataSet == null || !this._currentDataSet.next()) {
            if (!this._iterator.hasNext()) {
                this._currentDataSet = null;
                return false;
            }
            this._currentDataSet = this._iterator.next().get();
            assert (this.getHeader().size() == this._currentDataSet.getSelectItems().size());
        }
        return true;
    }

    @Override
    public Row getRow() {
        if (this._currentDataSet == null) {
            return null;
        }
        return this._currentDataSet.getRow();
    }

    @Override
    public DataSet getWrappedDataSet() {
        return this._currentDataSet;
    }
}

