/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.metamodel.data.ColorImpl;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.data.StyleImpl;
import org.apache.metamodel.util.EqualsBuilder;

public final class StyleBuilder {
    private static final Map<String, Style.Color> _colorCache = new WeakHashMap<String, Style.Color>();
    private boolean _bold;
    private boolean _italic;
    private boolean _underline;
    private Integer _fontSize;
    private Style.TextAlignment _alignment;
    private Style.Color _backgroundColor;
    private Style.Color _foregroundColor;
    private Style.SizeUnit _fontSizeUnit;
    private final Style.Color _defaultForegroundColor;
    private final Style.Color _defaultBackgroundColor;

    public StyleBuilder() {
        this(StyleBuilder.createColor((short)0, (short)0, (short)0), StyleBuilder.createColor((short)255, (short)255, (short)255));
    }

    public StyleBuilder(Style.Color defaultForegroundColor, Style.Color defaultBackgroundColor) {
        this._defaultForegroundColor = defaultForegroundColor;
        this._defaultBackgroundColor = defaultBackgroundColor;
    }

    public void reset() {
        this._bold = false;
        this._italic = false;
        this._underline = false;
        this._fontSize = null;
        this._alignment = null;
        this._backgroundColor = null;
        this._foregroundColor = null;
        this._fontSizeUnit = null;
    }

    public Style create() {
        StyleImpl style = new StyleImpl(this._bold, this._italic, this._underline, this._fontSize, this._fontSizeUnit, this._alignment, this._backgroundColor, this._foregroundColor);
        if (Style.NO_STYLE.equals(style)) {
            return Style.NO_STYLE;
        }
        return style;
    }

    public StyleBuilder bold() {
        this._bold = true;
        return this;
    }

    public StyleBuilder italic() {
        this._italic = true;
        return this;
    }

    public StyleBuilder underline() {
        this._underline = true;
        return this;
    }

    public static Style.Color createColor(String rgbColorCode) {
        assert (rgbColorCode.length() == 6);
        String redParth = rgbColorCode.substring(0, 2);
        String greenParth = rgbColorCode.substring(2, 4);
        String blueParth = rgbColorCode.substring(4, 6);
        return StyleBuilder.createColor(Integer.parseInt(redParth, 16), Integer.parseInt(greenParth, 16), Integer.parseInt(blueParth, 16));
    }

    public static Style.Color createColor(int r, int g, int b) {
        return StyleBuilder.createColor(StyleBuilder.toRgbComponent(r), StyleBuilder.toRgbComponent(g), StyleBuilder.toRgbComponent(b));
    }

    public static Style.Color createColor(short r, short g, short b) {
        String cacheId = r + "," + g + "," + b;
        Style.Color color = _colorCache.get(cacheId);
        if (color == null) {
            color = new ColorImpl(r, g, b);
            _colorCache.put(cacheId, color);
        }
        return color;
    }

    private static short toRgbComponent(int r) {
        if (r < 0) {
            r = 256 + r;
        }
        if (r > 255) {
            throw new IllegalArgumentException("RGB component cannot be higher than 255");
        }
        return (short)r;
    }

    public StyleBuilder foreground(String rgbColorCode) {
        return this.foreground(StyleBuilder.createColor(rgbColorCode));
    }

    public StyleBuilder foreground(short[] rgb) {
        assert (rgb.length == 3);
        return this.foreground(StyleBuilder.createColor(rgb[0], rgb[1], rgb[2]));
    }

    public StyleBuilder foreground(int r, int g, int b) {
        return this.foreground(StyleBuilder.createColor(r, g, b));
    }

    public StyleBuilder foreground(Style.Color color) {
        this._foregroundColor = EqualsBuilder.equals(this._defaultForegroundColor, color) ? null : color;
        return this;
    }

    public StyleBuilder background(String rgbColorCode) {
        return this.background(StyleBuilder.createColor(rgbColorCode));
    }

    public StyleBuilder background(short[] rgb) {
        assert (rgb.length == 3);
        return this.background(StyleBuilder.createColor(rgb[0], rgb[1], rgb[2]));
    }

    public StyleBuilder background(int r, int g, int b) {
        return this.background(StyleBuilder.createColor(r, g, b));
    }

    public StyleBuilder background(Style.Color color) {
        this._backgroundColor = EqualsBuilder.equals(this._defaultBackgroundColor, color) ? null : color;
        return this;
    }

    public StyleBuilder fontSize(int fontSize, Style.SizeUnit sizeUnit) {
        this._fontSize = fontSize;
        this._fontSizeUnit = sizeUnit;
        return this;
    }

    public StyleBuilder centerAligned() {
        this._alignment = Style.TextAlignment.CENTER;
        return this;
    }

    public StyleBuilder leftAligned() {
        this._alignment = Style.TextAlignment.LEFT;
        return this;
    }

    public StyleBuilder rightAligned() {
        this._alignment = Style.TextAlignment.RIGHT;
        return this;
    }

    public StyleBuilder justifyAligned() {
        this._alignment = Style.TextAlignment.JUSTIFY;
        return this;
    }
}

