/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;

public class SimpleDataSetHeader
implements DataSetHeader {
    private static final long serialVersionUID = 1L;
    private final List<SelectItem> _items;

    public SimpleDataSetHeader(List<SelectItem> items) {
        this._items = items;
    }

    public SimpleDataSetHeader(SelectItem[] selectItems) {
        this(Arrays.asList(selectItems));
    }

    public static SimpleDataSetHeader fromColumns(List<Column> cols) {
        return new SimpleDataSetHeader(cols.stream().map(SelectItem::new).collect(Collectors.toList()));
    }

    @Override
    public final List<SelectItem> getSelectItems() {
        return Collections.unmodifiableList(this._items);
    }

    @Override
    public final int size() {
        return this._items.size();
    }

    @Override
    public SelectItem getSelectItem(int index) {
        return this._items.get(index);
    }

    @Override
    public int indexOf(Column column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(new SelectItem(column));
    }

    @Override
    public int indexOf(SelectItem item) {
        if (item == null) {
            return -1;
        }
        int i = 0;
        for (SelectItem selectItem : this._items) {
            if (item == selectItem) {
                return i;
            }
            ++i;
        }
        i = 0;
        for (SelectItem selectItem : this._items) {
            if (item.equalsIgnoreAlias(selectItem, true)) {
                return i;
            }
            ++i;
        }
        i = 0;
        for (SelectItem selectItem : this._items) {
            if (item.equalsIgnoreAlias(selectItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._items == null ? 0 : this._items.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleDataSetHeader other = (SimpleDataSetHeader)obj;
        return !(this._items == null ? other._items != null : !this._items.equals(other._items));
    }

    public String toString() {
        return "DataSetHeader" + this._items.toString();
    }
}

