/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.Collection;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.IRowFilter;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.WrappingDataSet;

public final class FilteredDataSet
extends AbstractDataSet
implements WrappingDataSet {
    private final DataSet _dataSet;
    private final IRowFilter[] _filters;
    private Row _row;

    public FilteredDataSet(DataSet dataSet, Collection<? extends IRowFilter> filterItems) {
        this(dataSet, (IRowFilter[])filterItems.stream().toArray(IRowFilter[]::new));
    }

    public FilteredDataSet(DataSet dataSet, IRowFilter ... filters) {
        super(dataSet);
        this._dataSet = dataSet;
        this._filters = filters;
    }

    @Override
    public void close() {
        super.close();
        this._dataSet.close();
    }

    @Override
    public DataSet getWrappedDataSet() {
        return this._dataSet;
    }

    @Override
    public boolean next() {
        boolean next = false;
        while (this._dataSet.next()) {
            IRowFilter filter;
            Row row = this._dataSet.getRow();
            IRowFilter[] iRowFilterArray = this._filters;
            int n = iRowFilterArray.length;
            for (int i = 0; i < n && (next = (filter = iRowFilterArray[i]).accept(row)); ++i) {
            }
            if (!next) continue;
            this._row = row;
            break;
        }
        return next;
    }

    @Override
    public Row getRow() {
        return this._row;
    }
}

