/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import org.apache.metamodel.convert.DocumentConverter;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Document;
import org.apache.metamodel.data.DocumentSource;
import org.apache.metamodel.data.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSourceDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(DocumentSourceDataSet.class);
    private final DocumentSource _documentSource;
    private final DocumentConverter _converter;
    private volatile Document _document;

    public DocumentSourceDataSet(DataSetHeader header, DocumentSource documentSource, DocumentConverter converter) {
        super(header);
        this._documentSource = documentSource;
        this._converter = converter;
    }

    @Override
    public boolean next() {
        this._document = this._documentSource.next();
        return this._document != null;
    }

    @Override
    public Row getRow() {
        if (this._document == null) {
            return null;
        }
        DataSetHeader header = this.getHeader();
        return this._converter.convert(this._document, header);
    }

    @Override
    public void close() {
        super.close();
        try {
            this._documentSource.close();
        }
        catch (Exception e) {
            logger.warn("Failed to close DocumentSource: {}", (Object)this._document, (Object)e);
        }
    }
}

