/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.metamodel.data.AbstractRow;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.data.Style;

public final class DefaultRow
extends AbstractRow
implements Row {
    private static final long serialVersionUID = 1L;
    private final DataSetHeader _header;
    private final Object[] _values;
    private final Style[] _styles;

    public DefaultRow(DataSetHeader header, Object[] values, Style[] styles) {
        if (header == null) {
            throw new IllegalArgumentException("DataSet header cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        if (header.size() != values.length) {
            throw new IllegalArgumentException("Header size and values length must be equal. " + header.size() + " select items present in header and encountered these values: " + Arrays.toString(values));
        }
        if (styles != null) {
            if (values.length != styles.length) {
                throw new IllegalArgumentException("Values length and styles length must be equal. " + values.length + " values present and encountered these styles: " + Arrays.toString(styles));
            }
            boolean entirelyNoStyle = true;
            for (int i = 0; i < styles.length; ++i) {
                if (styles[i] == null) {
                    throw new IllegalArgumentException("Elements in the style array cannot be null");
                }
                if (!entirelyNoStyle || Style.NO_STYLE.equals(styles[i])) continue;
                entirelyNoStyle = false;
            }
            if (entirelyNoStyle) {
                styles = null;
            }
        }
        this._header = header;
        this._values = values;
        this._styles = styles;
    }

    public DefaultRow(DataSetHeader header, Object[] values) {
        this(header, values, null);
    }

    @Override
    public Object getValue(int index) throws ArrayIndexOutOfBoundsException {
        return this._values[index];
    }

    @Override
    public Object[] getValues() {
        return this._values;
    }

    @Override
    public Style getStyle(int index) throws IndexOutOfBoundsException {
        if (this._styles == null) {
            return Style.NO_STYLE;
        }
        return this._styles[index];
    }

    @Override
    public Style[] getStyles() {
        return this._styles;
    }

    @Override
    protected DataSetHeader getHeader() {
        return this._header;
    }

    private void readObject(ObjectInputStream stream) throws Exception {
        ObjectInputStream.GetField fields = stream.readFields();
        try {
            Object items = fields.get("_items", null);
            List itemsList = (List)items;
            SimpleDataSetHeader header = new SimpleDataSetHeader(itemsList);
            Field field = this.getClass().getDeclaredField("_header");
            field.setAccessible(true);
            field.set(this, header);
        }
        catch (IllegalArgumentException e) {
            this.setWhileDeserializing(fields, "_header");
        }
        this.setWhileDeserializing(fields, "_values");
        this.setWhileDeserializing(fields, "_styles");
    }

    private void setWhileDeserializing(ObjectInputStream.GetField fields, String fieldName) throws Exception {
        Object value = fields.get(fieldName, null);
        Field field = this.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(this, value);
    }
}

