/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.util.EqualsBuilder;

public class DataSetTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 267644807447629777L;
    private boolean _materialized;
    private final List<Row> _materializedRows = new ArrayList<Row>();
    private final DataSet _dataSet;
    private final List<SelectItem> _selectItems;

    public DataSetTableModel(DataSet dataSet) {
        this._dataSet = dataSet;
        this._selectItems = dataSet.getSelectItems();
        this._materialized = false;
    }

    public int hashCode() {
        return this._selectItems.hashCode() + this._materializedRows.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            DataSetTableModel that = (DataSetTableModel)obj;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this._materializedRows, that._materializedRows);
            eb.append(this._selectItems, that._selectItems);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return this._selectItems.size();
    }

    @Override
    public int getRowCount() {
        this.materialize();
        return this._materializedRows.size();
    }

    private void materialize() {
        if (!this._materialized) {
            try {
                while (this._dataSet.next()) {
                    this._materializedRows.add(this._dataSet.getRow());
                }
            }
            finally {
                this._dataSet.close();
            }
            this._materialized = true;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.materialize();
        return this._materializedRows.get(rowIndex).getValue(columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this._selectItems.get(column).getSuperQueryAlias(false);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        throw new UnsupportedOperationException("DataSetTableModels are immutable, so setValueAt() method is unsupported.");
    }
}

