/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.List;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.util.BaseObject;

final class ColorImpl
extends BaseObject
implements Style.Color {
    private static final long serialVersionUID = 1L;
    private final short _red;
    private final short _green;
    private final short _blue;

    public ColorImpl(short red, short green, short blue) {
        this.checkRange(red);
        this.checkRange(green);
        this.checkRange(blue);
        this._red = red;
        this._green = green;
        this._blue = blue;
    }

    private void checkRange(short rgbComponent) throws IllegalArgumentException {
        if (rgbComponent < 0 || rgbComponent > 255) {
            throw new IllegalArgumentException("All RGB components must be between 0 and 255. Found: " + rgbComponent);
        }
    }

    @Override
    public short getRed() {
        return this._red;
    }

    @Override
    public short getGreen() {
        return this._green;
    }

    @Override
    public short getBlue() {
        return this._blue;
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._red);
        identifiers.add(this._green);
        identifiers.add(this._blue);
    }

    @Override
    public String toString() {
        return "Color[" + this._red + "," + this._green + "," + this._blue + "]";
    }
}

