/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.RowBuilder;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.data.Style;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

public abstract class AbstractRowBuilder<RB extends RowBuilder<?>>
implements RowBuilder<RB> {
    private final Column[] _columns;
    private final Object[] _values;
    private final Style[] _styles;
    private final boolean[] _explicitNulls;

    public AbstractRowBuilder(Table table) {
        this(table.getColumns());
    }

    public AbstractRowBuilder(List<Column> columns) {
        this._columns = columns.toArray(new Column[columns.size()]);
        this._explicitNulls = new boolean[this._columns.length];
        this._values = new Object[this._columns.length];
        this._styles = new Style[this._columns.length];
    }

    protected boolean[] getExplicitNulls() {
        return this._explicitNulls;
    }

    protected Object[] getValues() {
        return this._values;
    }

    protected Column[] getColumns() {
        return this._columns;
    }

    protected Style[] getStyles() {
        return this._styles;
    }

    @Override
    public final Row toRow() {
        return new DefaultRow(new SimpleDataSetHeader(Arrays.stream(this._columns).map(SelectItem::new).collect(Collectors.toList())), this._values);
    }

    @Override
    public final RB value(Column column, Object value) {
        return this.value(column, value, null);
    }

    @Override
    public RB value(Column column, Object value, Style style) {
        if (column == null) {
            throw new IllegalArgumentException("Column cannot be null");
        }
        boolean written = false;
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].equals(column)) continue;
            this.value(i, value, style);
            written = true;
            break;
        }
        if (!written) {
            throw new IllegalArgumentException("No such column in table: " + column);
        }
        AbstractRowBuilder result = this;
        return (RB)result;
    }

    @Override
    public RB value(int columnIndex, Object value) {
        return this.value(columnIndex, value, null);
    }

    @Override
    public final RB value(int columnIndex, Object value, Style style) {
        this._values[columnIndex] = value;
        this._styles[columnIndex] = style;
        this._explicitNulls[columnIndex] = value == null;
        AbstractRowBuilder result = this;
        return (RB)result;
    }

    @Override
    public RB value(String columnName, Object value) {
        return this.value(columnName, value, null);
    }

    @Override
    public final RB value(String columnName, Object value, Style style) {
        if (columnName == null) {
            throw new IllegalArgumentException("Column name cannot be null");
        }
        for (int i = 0; i < this._columns.length; ++i) {
            Column column = this._columns[i];
            if (!column.getName().equalsIgnoreCase(columnName)) continue;
            return this.value(i, value, style);
        }
        throw new IllegalArgumentException("No such column in table: " + columnName + ", available columns are: " + Arrays.toString(this._columns));
    }

    @Override
    public boolean isSet(Column column) {
        for (int i = 0; i < this._columns.length; ++i) {
            if (!this._columns[i].equals(column)) continue;
            return this._values[i] != null || this._explicitNulls[i];
        }
        return false;
    }
}

