/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.metamodel.data.CachingDataSetHeader;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DataSetIterator;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.util.BaseObject;

public abstract class AbstractDataSet
extends BaseObject
implements DataSet {
    private final DataSetHeader _header;

    public AbstractDataSet(SelectItem[] selectItems) {
        this(Arrays.asList(selectItems));
    }

    public AbstractDataSet(List<SelectItem> selectItems) {
        this(new CachingDataSetHeader(selectItems));
    }

    public AbstractDataSet(DataSet dataSet) {
        this._header = dataSet instanceof AbstractDataSet ? ((AbstractDataSet)dataSet).getHeader() : new CachingDataSetHeader(dataSet.getSelectItems());
    }

    public AbstractDataSet(DataSetHeader header) {
        this._header = Objects.requireNonNull(header);
    }

    @Override
    public List<SelectItem> getSelectItems() {
        return this.getHeader().getSelectItems();
    }

    protected DataSetHeader getHeader() {
        return this._header;
    }

    @Override
    public final int indexOf(SelectItem item) {
        return this.getHeader().indexOf(item);
    }

    @Override
    public void close() {
    }

    @Override
    public final List<Object[]> toObjectArrays() {
        try {
            ArrayList<Object[]> objects = new ArrayList<Object[]>();
            while (this.next()) {
                Row row = this.getRow();
                objects.add(row.getValues());
            }
            ArrayList<Object[]> arrayList = objects;
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    @Override
    public String toString() {
        return "DataSet[selectItems=" + Arrays.toString(this.getSelectItems().toArray()) + "]";
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.getClass());
        identifiers.add(this.getSelectItems());
    }

    @Override
    public List<Row> toRows() {
        try {
            ArrayList<Row> result = new ArrayList<Row>();
            while (this.next()) {
                result.add(this.getRow());
            }
            ArrayList<Row> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return new DataSetIterator(this);
    }
}

