/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.convert;

import java.util.HashMap;
import java.util.Map;
import org.apache.metamodel.convert.Converters;
import org.apache.metamodel.convert.TypeConverter;
import org.apache.metamodel.insert.RowInsertionBuilder;
import org.apache.metamodel.intercept.RowInsertionInterceptor;
import org.apache.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertedRowInsertionInterceptor
implements RowInsertionInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ConvertedRowInsertionInterceptor.class);
    private final Map<Column, TypeConverter<?, ?>> _converters;

    public ConvertedRowInsertionInterceptor() {
        this(new HashMap());
    }

    public ConvertedRowInsertionInterceptor(Map<Column, TypeConverter<?, ?>> converters) {
        this._converters = converters;
    }

    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        if (converter == null) {
            this._converters.remove(column);
        } else {
            this._converters.put(column, converter);
        }
    }

    @Override
    public RowInsertionBuilder intercept(RowInsertionBuilder insert) {
        if (this._converters.isEmpty()) {
            return insert;
        }
        logger.debug("Insert statement before conversion: {}", (Object)insert);
        insert = Converters.convertRow(insert, this._converters);
        logger.debug("Insert statement after conversion:  {}", (Object)insert);
        return insert;
    }
}

