/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.convert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.convert.ConvertedDataSet;
import org.apache.metamodel.convert.HasReadTypeConverters;
import org.apache.metamodel.convert.TypeConverter;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.intercept.DataSetInterceptor;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;

public class ConvertedDataSetInterceptor
implements DataSetInterceptor,
HasReadTypeConverters {
    private Map<Column, TypeConverter<?, ?>> _converters;

    public ConvertedDataSetInterceptor() {
        this(new HashMap());
    }

    public ConvertedDataSetInterceptor(Map<Column, TypeConverter<?, ?>> converters) {
        this._converters = converters;
    }

    @Override
    public void addConverter(Column column, TypeConverter<?, ?> converter) {
        if (converter == null) {
            this._converters.remove(column);
        } else {
            this._converters.put(column, converter);
        }
    }

    protected Map<Column, TypeConverter<?, ?>> getConverters(DataSet dataSet) {
        return this._converters;
    }

    @Override
    public final DataSet intercept(DataSet dataSet) {
        Map<Column, TypeConverter<?, ?>> converters = this.getConverters(dataSet);
        if (converters.isEmpty()) {
            return dataSet;
        }
        boolean hasConverter = false;
        List<SelectItem> selectItems = dataSet.getSelectItems();
        TypeConverter[] converterArray = new TypeConverter[selectItems.size()];
        for (int i = 0; i < selectItems.size(); ++i) {
            TypeConverter<?, ?> converter;
            SelectItem selectItem = selectItems.get(i);
            Column column = selectItem.getColumn();
            if (column == null || selectItem.getAggregateFunction() != null || (converter = converters.get(column)) == null) continue;
            hasConverter = true;
            converterArray[i] = converter;
        }
        if (!hasConverter) {
            return dataSet;
        }
        return new ConvertedDataSet(dataSet, converterArray);
    }
}

