/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.metamodel.DefaultUpdateSummary;
import org.apache.metamodel.UpdateSummary;

public class UpdateSummaryBuilder {
    private int _inserts;
    private int _updates;
    private int _deletes;
    private Set<Object> _generatedKeys;

    public UpdateSummary build() {
        Integer insertedRows = this._inserts == -1 ? null : Integer.valueOf(this._inserts);
        Integer updatedRows = this._updates == -1 ? null : Integer.valueOf(this._updates);
        Integer deletedRows = this._deletes == -1 ? null : Integer.valueOf(this._deletes);
        LinkedHashSet<Object> generatedKeys = this._generatedKeys != null ? new LinkedHashSet<Object>(this._generatedKeys) : null;
        return new DefaultUpdateSummary(insertedRows, updatedRows, deletedRows, generatedKeys);
    }

    public UpdateSummaryBuilder addInsert() {
        return this.addInserts(1);
    }

    public UpdateSummaryBuilder addInserts(int inserts) {
        if (this._inserts != -1) {
            this._inserts += inserts;
        }
        return this;
    }

    public UpdateSummaryBuilder makeInsertsUnknown() {
        this._inserts = -1;
        return this;
    }

    public UpdateSummaryBuilder addUpdate() {
        return this.addUpdates(1);
    }

    public UpdateSummaryBuilder addUpdates(int updates) {
        if (this._updates != -1) {
            this._updates += updates;
        }
        return this;
    }

    public UpdateSummaryBuilder makeUpdatesUnknown() {
        this._updates = -1;
        return this;
    }

    public UpdateSummaryBuilder addDelete() {
        return this.addDeletes(1);
    }

    public UpdateSummaryBuilder addDeletes(int deletes) {
        if (this._deletes != -1) {
            this._deletes += deletes;
        }
        return this;
    }

    public UpdateSummaryBuilder makeDeletesUnknown() {
        this._deletes = -1;
        return this;
    }

    public UpdateSummaryBuilder addGeneratedKey(Object key) {
        if (this._generatedKeys == null) {
            this._generatedKeys = new HashSet<Object>();
        }
        this._generatedKeys.add(key);
        return this;
    }

    public UpdateSummaryBuilder addGeneratedKeys(Object ... keys) {
        if (this._generatedKeys == null) {
            this._generatedKeys = new HashSet<Object>();
        }
        for (Object key : keys) {
            this._generatedKeys.add(key);
        }
        return this;
    }

    public UpdateSummaryBuilder addGeneratedKeys(Iterable<?> keys) {
        if (this._generatedKeys == null) {
            this._generatedKeys = new HashSet<Object>();
        }
        for (Object key : keys) {
            this._generatedKeys.add(key);
        }
        return this;
    }

    public UpdateSummaryBuilder makeGeneratedKeysUnknown() {
        this._generatedKeys = null;
        return this;
    }
}

