/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveBytesArrayWritable;
import org.elasticsearch.hadoop.hive.HiveBytesConverter;
import org.elasticsearch.hadoop.hive.HiveFieldExtractor;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.hive.HiveValueWriter;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommands;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesArray;
import org.elasticsearch.hadoop.util.EsMajorVersion;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.StringUtils;

public class EsSerDe
extends AbstractSerDe {
    private static Log log = LogFactory.getLog(EsSerDe.class);
    private Properties tableProperties;
    private Configuration cfg;
    private Settings settings;
    private StructObjectInspector inspector;
    private final BytesArray scratchPad = new BytesArray(512);
    private final HiveType hiveType = new HiveType(null, null);
    private final HiveBytesArrayWritable result = new HiveBytesArrayWritable();
    private StructTypeInfo structTypeInfo;
    private FieldAlias alias;
    private EsMajorVersion version;
    private BulkCommand command;
    private boolean writeInitialized = false;
    private boolean trace = false;
    private boolean outputJSON = false;
    private Text jsonFieldName = null;

    public void initialize(Configuration conf, Properties tbl, Properties partitionProperties) throws SerDeException {
        this.inspector = HiveUtils.structObjectInspector(tbl);
        this.structTypeInfo = HiveUtils.typeInfo(this.inspector);
        this.cfg = conf;
        this.settings = this.cfg != null ? HadoopSettingsManager.loadFrom(this.cfg).merge(tbl) : HadoopSettingsManager.loadFrom(tbl);
        this.alias = HiveUtils.alias(this.settings);
        this.version = InitializationUtils.discoverEsVersion(this.settings, log);
        HiveUtils.fixHive13InvalidComments(this.settings, tbl);
        this.tableProperties = tbl;
        this.trace = log.isTraceEnabled();
        this.outputJSON = this.settings.getOutputAsJson();
        if (this.outputJSON) {
            this.jsonFieldName = new Text(HiveUtils.discoverJsonFieldName(this.settings, this.alias));
        }
    }

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        this.initialize(conf, tbl, new Properties());
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (blob == null || blob instanceof NullWritable) {
            return null;
        }
        Writable deserialize = blob;
        if (this.outputJSON) {
            deserialize = this.wrapJsonData(blob);
        }
        Object des = EsSerDe.hiveFromWritable((TypeInfo)this.structTypeInfo, deserialize, this.alias);
        if (this.trace) {
            log.trace((Object)String.format("Deserialized [%s] to [%s]", blob, des));
        }
        return des;
    }

    private Writable wrapJsonData(Writable blob) {
        Assert.isTrue(blob instanceof Text, "Property `es.output.json` is enabled, but returned data was not of type Text...");
        switch (this.structTypeInfo.getCategory()) {
            case STRUCT: {
                MapWritable mapContainer = new MapWritable();
                mapContainer.put(this.jsonFieldName, blob);
                return (Writable)mapContainer;
            }
        }
        throw new EsHadoopIllegalStateException("Could not correctly wrap JSON data for structural type " + this.structTypeInfo.getCategory());
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return HiveBytesArrayWritable.class;
    }

    public Writable serialize(Object data, ObjectInspector objInspector) throws SerDeException {
        this.lazyInitializeWrite();
        this.scratchPad.reset();
        this.hiveType.setObjectInspector(objInspector);
        this.hiveType.setObject(data);
        this.command.write(this.hiveType).copyTo(this.scratchPad);
        this.result.setContent(this.scratchPad);
        return this.result;
    }

    private void lazyInitializeWrite() {
        if (this.writeInitialized) {
            return;
        }
        this.writeInitialized = true;
        Settings settings = HadoopSettingsManager.loadFrom(this.tableProperties);
        InitializationUtils.setValueWriterIfNotSet(settings, HiveValueWriter.class, log);
        InitializationUtils.setFieldExtractorIfNotSet(settings, HiveFieldExtractor.class, log);
        InitializationUtils.setBytesConverterIfNeeded(settings, HiveBytesConverter.class, log);
        this.command = BulkCommands.create(settings, null, this.version);
    }

    static Object hiveFromWritable(TypeInfo type, Writable data, FieldAlias alias) {
        if (data == null || data instanceof NullWritable) {
            return null;
        }
        switch (type.getCategory()) {
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)type;
                TypeInfo listElementType = listType.getListElementTypeInfo();
                ArrayWritable aw = (ArrayWritable)data;
                ArrayList<Object> list = new ArrayList<Object>();
                for (Writable writable : aw.get()) {
                    list.add(EsSerDe.hiveFromWritable(listElementType, writable, alias));
                }
                return list;
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)type;
                Map mw = (Map)data;
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                for (Map.Entry entry : mw.entrySet()) {
                    map.put(EsSerDe.hiveFromWritable(mapType.getMapKeyTypeInfo(), (Writable)entry.getKey(), alias), EsSerDe.hiveFromWritable(mapType.getMapValueTypeInfo(), (Writable)entry.getValue(), alias));
                }
                return map;
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)type;
                ArrayList names = structType.getAllStructFieldNames();
                ArrayList info = structType.getAllStructFieldTypeInfos();
                ArrayList<Object> struct = new ArrayList<Object>();
                MapWritable map = (MapWritable)data;
                Text reuse = new Text();
                for (int index = 0; index < names.size(); ++index) {
                    String esAlias = alias.toES((String)names.get(index));
                    MapWritable result = map;
                    for (String level : StringUtils.tokenize(esAlias, ".")) {
                        reuse.set(level);
                        if ((result = result.get((Object)reuse)) != null) continue;
                        break;
                    }
                    struct.add(EsSerDe.hiveFromWritable((TypeInfo)info.get(index), (Writable)result, alias));
                }
                return struct;
            }
            case UNION: {
                throw new UnsupportedOperationException("union not yet supported");
            }
        }
        return data;
    }
}

