/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.upgrades;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SingleFeatureMigrationResult
implements SimpleDiffable<SingleFeatureMigrationResult>,
Writeable,
ToXContent {
    private static final String NAME = "feature_migration_status";
    private static final ParseField SUCCESS_FIELD = new ParseField("successful", new String[0]);
    private static final ParseField FAILED_INDEX_NAME_FIELD = new ParseField("failed_index", new String[0]);
    private static final ParseField EXCEPTION_FIELD = new ParseField("exception", new String[0]);
    private final boolean successful;
    @Nullable
    private final String failedIndexName;
    @Nullable
    private final Exception exception;
    private static final ConstructingObjectParser<SingleFeatureMigrationResult, Void> PARSER = new ConstructingObjectParser("feature_migration_status", a -> new SingleFeatureMigrationResult((Boolean)a[0], (String)a[1], (Exception)a[2]));

    private SingleFeatureMigrationResult(boolean successful, String failedIndexName, Exception exception) {
        this.successful = successful;
        if (!successful) {
            Objects.requireNonNull(failedIndexName, "failed index name must be present for failed feature migration statuses");
            Objects.requireNonNull(exception, "exception details must be present for failed feature migration statuses");
        }
        this.failedIndexName = failedIndexName;
        this.exception = exception;
    }

    SingleFeatureMigrationResult(StreamInput in) throws IOException {
        this.successful = in.readBoolean();
        if (!this.successful) {
            this.failedIndexName = in.readString();
            this.exception = in.readException();
        } else {
            this.failedIndexName = null;
            this.exception = null;
        }
    }

    public static SingleFeatureMigrationResult fromXContent(XContentParser parser) {
        return (SingleFeatureMigrationResult)PARSER.apply(parser, null);
    }

    public static SingleFeatureMigrationResult success() {
        return new SingleFeatureMigrationResult(true, null, null);
    }

    public static SingleFeatureMigrationResult failure(String failedIndexName, Exception exception) {
        return new SingleFeatureMigrationResult(false, failedIndexName, exception);
    }

    public boolean succeeded() {
        return this.successful;
    }

    @Nullable
    public String getFailedIndexName() {
        return this.failedIndexName;
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.successful);
        if (!this.successful) {
            out.writeString(this.failedIndexName);
            out.writeException(this.exception);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SUCCESS_FIELD.getPreferredName(), this.successful);
        if (!this.successful) {
            builder.field(FAILED_INDEX_NAME_FIELD.getPreferredName(), this.failedIndexName);
            builder.startObject(EXCEPTION_FIELD.getPreferredName());
            ElasticsearchException.generateThrowableXContent(builder, params, this.exception);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleFeatureMigrationResult)) {
            return false;
        }
        SingleFeatureMigrationResult that = (SingleFeatureMigrationResult)o;
        return this.successful == that.successful && Objects.equals(this.failedIndexName, that.failedIndexName);
    }

    public int hashCode() {
        return Objects.hash(this.successful, this.failedIndexName);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SUCCESS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILED_INDEX_NAME_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), EXCEPTION_FIELD);
    }
}

