/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.SizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public final class FixedExecutorBuilder
extends ExecutorBuilder<FixedExecutorSettings> {
    private final Setting<Integer> sizeSetting;
    private final Setting<Integer> queueSizeSetting;
    private final boolean trackEWMA;

    FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, boolean trackEWMA) {
        this(settings, name, size, queueSize, "thread_pool." + name, trackEWMA);
    }

    public FixedExecutorBuilder(Settings settings, String name, int size, int queueSize, String prefix, boolean trackEWMA) {
        super(name);
        String sizeKey = FixedExecutorBuilder.settingsKey(prefix, "size");
        this.sizeSetting = new Setting<Integer>(sizeKey, Integer.toString(size), s -> Setting.parseInt(s, 1, FixedExecutorBuilder.applyHardSizeLimit(settings, name), sizeKey), Setting.Property.NodeScope);
        String queueSizeKey = FixedExecutorBuilder.settingsKey(prefix, "queue_size");
        this.queueSizeSetting = Setting.intSetting(queueSizeKey, queueSize, Setting.Property.NodeScope);
        this.trackEWMA = trackEWMA;
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.sizeSetting, this.queueSizeSetting);
    }

    @Override
    FixedExecutorSettings getSettings(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int size = this.sizeSetting.get(settings);
        int queueSize = this.queueSizeSetting.get(settings);
        return new FixedExecutorSettings(nodeName, size, queueSize);
    }

    @Override
    ThreadPool.ExecutorHolder build(FixedExecutorSettings settings, ThreadContext threadContext) {
        int size = settings.size;
        int queueSize = settings.queueSize;
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(EsExecutors.threadName(settings.nodeName, this.name()));
        EsThreadPoolExecutor executor = EsExecutors.newFixed(settings.nodeName + "/" + this.name(), size, queueSize, threadFactory, threadContext, this.trackEWMA);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.FIXED, size, size, null, queueSize < 0 ? null : new SizeValue(queueSize));
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], size [%d], queue size [%s]", info.getName(), info.getMax(), info.getQueueSize() == null ? "unbounded" : info.getQueueSize());
    }

    static class FixedExecutorSettings
    extends ExecutorBuilder.ExecutorSettings {
        private final int size;
        private final int queueSize;

        FixedExecutorSettings(String nodeName, int size, int queueSize) {
            super(nodeName);
            this.size = size;
            this.queueSize = queueSize;
        }
    }
}

