/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParserHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.RawTaskStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record TaskInfo(TaskId taskId, String type, String action, String description, Task.Status status, long startTime, long runningTimeNanos, boolean cancellable, boolean cancelled, TaskId parentTaskId, Map<String, String> headers) implements Writeable,
ToXContentFragment
{
    static final String INCLUDE_CANCELLED_PARAM = "include_cancelled";
    public static final ConstructingObjectParser<TaskInfo, Void> PARSER = new ConstructingObjectParser("task_info", true, a -> {
        Map<String, String> headers;
        int i = 0;
        TaskId id = new TaskId((String)a[i++], (Long)a[i++]);
        String type = (String)a[i++];
        String action = (String)a[i++];
        String description = (String)a[i++];
        BytesReference statusBytes = (BytesReference)a[i++];
        long startTime = (Long)a[i++];
        long runningTimeNanos = (Long)a[i++];
        boolean cancellable = (Boolean)a[i++];
        boolean cancelled = a[i++] == Boolean.TRUE;
        String parentTaskIdString = (String)a[i++];
        if ((headers = (Map<String, String>)a[i++]) == null) {
            headers = Collections.emptyMap();
        }
        RawTaskStatus status = statusBytes == null ? null : new RawTaskStatus(statusBytes);
        TaskId parentTaskId = parentTaskIdString == null ? TaskId.EMPTY_TASK_ID : new TaskId(parentTaskIdString);
        return new TaskInfo(id, type, action, description, status, startTime, runningTimeNanos, cancellable, cancelled, parentTaskId, headers);
    });

    public TaskInfo {
        assert (cancellable || !cancelled) : "uncancellable task cannot be cancelled";
    }

    public static TaskInfo from(StreamInput in) throws IOException {
        return new TaskInfo(TaskId.readFromStream(in), in.readString(), in.readString(), in.readOptionalString(), in.readOptionalNamedWriteable(Task.Status.class), in.readLong(), in.readLong(), in.readBoolean(), in.readBoolean(), TaskId.readFromStream(in), in.readMap(StreamInput::readString, StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.taskId.writeTo(out);
        out.writeString(this.type);
        out.writeString(this.action);
        out.writeOptionalString(this.description);
        out.writeOptionalNamedWriteable(this.status);
        out.writeLong(this.startTime);
        out.writeLong(this.runningTimeNanos);
        out.writeBoolean(this.cancellable);
        out.writeBoolean(this.cancelled);
        this.parentTaskId.writeTo(out);
        out.writeMap(this.headers, StreamOutput::writeString, StreamOutput::writeString);
    }

    public long id() {
        return this.taskId.getId();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("node", this.taskId.getNodeId());
        builder.field("id", this.taskId.getId());
        builder.field("type", this.type);
        builder.field("action", this.action);
        if (this.status != null) {
            builder.field("status", (ToXContent)this.status, params);
        }
        if (this.description != null) {
            builder.field("description", this.description);
        }
        builder.timeField("start_time_in_millis", "start_time", this.startTime);
        if (builder.humanReadable()) {
            builder.field("running_time", new TimeValue(this.runningTimeNanos, TimeUnit.NANOSECONDS).toString());
        }
        builder.field("running_time_in_nanos", this.runningTimeNanos);
        builder.field("cancellable", this.cancellable);
        if (params.paramAsBoolean(INCLUDE_CANCELLED_PARAM, true) && this.cancellable) {
            builder.field("cancelled", this.cancelled);
        }
        if (this.parentTaskId.isSet()) {
            builder.field("parent_task_id", this.parentTaskId.toString());
        }
        builder.startObject("headers");
        for (Map.Entry<String, String> attribute : this.headers.entrySet()) {
            builder.field(attribute.getKey(), attribute.getValue());
        }
        builder.endObject();
        return builder;
    }

    public static TaskInfo fromXContent(XContentParser parser) {
        return (TaskInfo)PARSER.apply(parser, null);
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("action", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
        ObjectParserHelper.declareRawObject(PARSER, ConstructingObjectParser.optionalConstructorArg(), new ParseField("status", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("start_time_in_millis", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("running_time_in_nanos", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("cancellable", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("cancelled", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("parent_task_id", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapStrings(), new ParseField("headers", new String[0]));
    }
}

