/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class KnnVectorQueryBuilder
extends AbstractQueryBuilder<KnnVectorQueryBuilder> {
    public static final String NAME = "knn";
    private final String fieldName;
    private final float[] queryVector;
    private final byte[] byteQueryVector;
    private final int numCands;
    private final List<QueryBuilder> filterQueries;

    public KnnVectorQueryBuilder(String fieldName, float[] queryVector, int numCands) {
        this.fieldName = fieldName;
        this.queryVector = Objects.requireNonNull(queryVector);
        this.byteQueryVector = null;
        this.numCands = numCands;
        this.filterQueries = new ArrayList<QueryBuilder>();
    }

    public KnnVectorQueryBuilder(String fieldName, byte[] queryVector, int numCands) {
        this.fieldName = fieldName;
        this.queryVector = null;
        this.byteQueryVector = Objects.requireNonNull(queryVector);
        this.numCands = numCands;
        this.filterQueries = new ArrayList<QueryBuilder>();
    }

    public KnnVectorQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.numCands = in.readVInt();
        if (in.getTransportVersion().before(TransportVersion.V_8_7_0)) {
            this.queryVector = in.readFloatArray();
            this.byteQueryVector = null;
        } else {
            this.queryVector = in.readBoolean() ? in.readFloatArray() : null;
            this.byteQueryVector = in.readBoolean() ? in.readByteArray() : null;
        }
        this.filterQueries = in.getTransportVersion().before(TransportVersion.V_8_2_0) ? new ArrayList<QueryBuilder>() : KnnVectorQueryBuilder.readQueries(in);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Nullable
    public float[] queryVector() {
        return this.queryVector;
    }

    @Nullable
    public byte[] getByteQueryVector() {
        return this.byteQueryVector;
    }

    public int numCands() {
        return this.numCands;
    }

    public List<QueryBuilder> filterQueries() {
        return this.filterQueries;
    }

    public KnnVectorQueryBuilder addFilterQuery(QueryBuilder filterQuery) {
        Objects.requireNonNull(filterQuery);
        this.filterQueries.add(filterQuery);
        return this;
    }

    public KnnVectorQueryBuilder addFilterQueries(List<QueryBuilder> filterQueries) {
        Objects.requireNonNull(filterQueries);
        this.filterQueries.addAll(filterQueries);
        return this;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeVInt(this.numCands);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_7_0)) {
            boolean queryVectorNotNull = this.queryVector != null;
            out.writeBoolean(queryVectorNotNull);
            if (queryVectorNotNull) {
                out.writeFloatArray(this.queryVector);
            }
            boolean byteVectorNotNull = this.byteQueryVector != null;
            out.writeBoolean(byteVectorNotNull);
            if (byteVectorNotNull) {
                out.writeByteArray(this.byteQueryVector);
            }
        } else {
            float[] f;
            if (this.queryVector != null) {
                f = this.queryVector;
            } else {
                f = new float[this.byteQueryVector.length];
                for (int i = 0; i < this.byteQueryVector.length; ++i) {
                    f[i] = this.byteQueryVector[i];
                }
            }
            out.writeFloatArray(f);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_2_0)) {
            KnnVectorQueryBuilder.writeQueries(out, this.filterQueries);
        }
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).field("field", this.fieldName).field("vector", (Object)(this.queryVector != null ? this.queryVector : (float[])this.byteQueryVector)).field("num_candidates", this.numCands);
        if (!this.filterQueries.isEmpty()) {
            builder.startArray("filters");
            for (QueryBuilder filterQuery : this.filterQueries) {
                filterQuery.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        boolean changed = false;
        ArrayList<QueryBuilder> rewrittenQueries = new ArrayList<QueryBuilder>(this.filterQueries.size());
        for (QueryBuilder query : this.filterQueries) {
            QueryBuilder rewrittenQuery = query.rewrite(queryRewriteContext);
            if (rewrittenQuery instanceof MatchNoneQueryBuilder) {
                return rewrittenQuery;
            }
            if (rewrittenQuery != query) {
                changed = true;
            }
            rewrittenQueries.add(rewrittenQuery);
        }
        if (changed) {
            return this.byteQueryVector != null ? new KnnVectorQueryBuilder(this.fieldName, this.byteQueryVector, this.numCands).addFilterQueries(rewrittenQueries) : new KnnVectorQueryBuilder(this.fieldName, this.queryVector, this.numCands).addFilterQueries(rewrittenQueries);
        }
        return this;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            throw new IllegalArgumentException("field [" + this.fieldName + "] does not exist in the mapping");
        }
        if (!(fieldType instanceof DenseVectorFieldMapper.DenseVectorFieldType)) {
            throw new IllegalArgumentException("[knn] queries are only supported on [dense_vector] fields");
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (QueryBuilder query : this.filterQueries) {
            builder.add(query.toQuery(context), BooleanClause.Occur.FILTER);
        }
        BooleanQuery booleanQuery = builder.build();
        BooleanQuery filterQuery = booleanQuery.clauses().isEmpty() ? null : booleanQuery;
        DenseVectorFieldMapper.DenseVectorFieldType vectorFieldType = (DenseVectorFieldMapper.DenseVectorFieldType)fieldType;
        return this.queryVector != null ? vectorFieldType.createKnnQuery(this.queryVector, this.numCands, (Query)filterQuery) : vectorFieldType.createKnnQuery(this.byteQueryVector, this.numCands, (Query)filterQuery);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, Arrays.hashCode(this.queryVector), Arrays.hashCode(this.byteQueryVector), this.numCands, this.filterQueries);
    }

    @Override
    protected boolean doEquals(KnnVectorQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Arrays.equals(this.queryVector, other.queryVector) && Arrays.equals(this.byteQueryVector, other.byteQueryVector) && this.numCands == other.numCands && Objects.equals(this.filterQueries, other.filterQueries);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_8_0_0;
    }
}

