/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.dfs;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.profile.AbstractProfileBreakdown;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.SearchProfileDfsPhaseResult;
import org.elasticsearch.search.profile.dfs.DfsTimingType;
import org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public class DfsProfiler
extends AbstractProfileBreakdown<DfsTimingType> {
    private long startTime;
    private long totalTime;
    private final List<QueryProfiler> knnQueryProfilers = new ArrayList<QueryProfiler>();
    private boolean collectorSet = false;

    public DfsProfiler() {
        super(DfsTimingType.class);
    }

    public void start() {
        this.startTime = System.nanoTime();
    }

    public void stop() {
        this.totalTime = System.nanoTime() - this.startTime;
    }

    public void startTimer(DfsTimingType dfsTimingType) {
        this.getTimer(dfsTimingType).start();
    }

    public void stopTimer(DfsTimingType dfsTimingType) {
        this.getTimer(dfsTimingType).stop();
    }

    public QueryProfiler addQueryProfiler(InternalProfileCollector collector) {
        QueryProfiler queryProfiler = new QueryProfiler();
        queryProfiler.setCollector(collector);
        this.knnQueryProfilers.add(queryProfiler);
        this.collectorSet = true;
        return queryProfiler;
    }

    public SearchProfileDfsPhaseResult buildDfsPhaseResults() {
        ArrayList<QueryProfileShardResult> queryProfileShardResult;
        ProfileResult dfsProfileResult = new ProfileResult("statistics", "collect term statistics", this.toBreakdownMap(), this.toDebugMap(), this.totalTime, List.of());
        if (this.collectorSet) {
            queryProfileShardResult = new ArrayList<QueryProfileShardResult>(this.knnQueryProfilers.size());
            for (QueryProfiler queryProfiler : this.knnQueryProfilers) {
                queryProfileShardResult.add(new QueryProfileShardResult(queryProfiler.getTree(), queryProfiler.getRewriteTime(), queryProfiler.getCollector()));
            }
        } else {
            queryProfileShardResult = null;
        }
        return new SearchProfileDfsPhaseResult(dfsProfileResult, queryProfileShardResult);
    }
}

