/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;

public interface FieldValues<T> {
    public void valuesForDoc(SearchLookup var1, LeafReaderContext var2, int var3, Consumer<T> var4);

    public static ValueFetcher valueFetcher(FieldValues<?> fieldValues, SearchExecutionContext context) {
        return FieldValues.valueFetcher(fieldValues, v -> v, context);
    }

    public static ValueFetcher valueFetcher(final FieldValues<?> fieldValues, final Function<Object, Object> formatter, final SearchExecutionContext context) {
        return new ValueFetcher(){
            LeafReaderContext ctx;

            @Override
            public void setNextReader(LeafReaderContext context2) {
                this.ctx = context2;
            }

            @Override
            public List<Object> fetchValues(Source lookup, int doc, List<Object> ignoredValues) {
                ArrayList<Object> values = new ArrayList<Object>();
                try {
                    fieldValues.valuesForDoc(context.lookup(), this.ctx, doc, v -> values.add(formatter.apply(v)));
                }
                catch (Exception e) {
                    ignoredValues.addAll(values);
                }
                return values;
            }
        };
    }

    public static <T> ValueFetcher valueListFetcher(final FieldValues<T> fieldValues, final Function<List<T>, List<Object>> formatter, final SearchExecutionContext context) {
        return new ValueFetcher(){
            LeafReaderContext ctx;

            @Override
            public void setNextReader(LeafReaderContext context2) {
                this.ctx = context2;
            }

            @Override
            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) {
                ArrayList values = new ArrayList();
                try {
                    fieldValues.valuesForDoc(context.lookup(), this.ctx, doc, values::add);
                }
                catch (Exception e) {
                    ignoredValues.addAll(values);
                }
                return (List)formatter.apply(values);
            }
        };
    }
}

