/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchSortValuesAndFormats;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class ShardSearchRequest
extends TransportRequest
implements IndicesRequest {
    private final String clusterAlias;
    private final ShardId shardId;
    private final int shardRequestIndex;
    private final int numberOfShards;
    private final long waitForCheckpoint;
    private final TimeValue waitForCheckpointsTimeout;
    private final SearchType searchType;
    private final Scroll scroll;
    private final float indexBoost;
    private Boolean requestCache;
    private final long nowInMillis;
    private final boolean allowPartialSearchResults;
    private final OriginalIndices originalIndices;
    private boolean canReturnNullResponseIfMatchNoDocs;
    private SearchSortValuesAndFormats bottomSortValues;
    private AliasFilter aliasFilter;
    private SearchSourceBuilder source;
    private final ShardSearchContextId readerId;
    private final TimeValue keepAlive;
    private final TransportVersion channelVersion;
    private final boolean forceSyntheticSource;
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final ThreadLocal<BytesStreamOutput> scratch = ThreadLocal.withInitial(BytesStreamOutput::new);

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int shardRequestIndex, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias) {
        this(originalIndices, searchRequest, shardId, shardRequestIndex, numberOfShards, aliasFilter, indexBoost, nowInMillis, clusterAlias, null, null);
    }

    public ShardSearchRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int shardRequestIndex, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, ShardSearchContextId readerId, TimeValue keepAlive) {
        this(originalIndices, shardId, shardRequestIndex, numberOfShards, searchRequest.searchType(), searchRequest.source(), searchRequest.requestCache(), aliasFilter, indexBoost, searchRequest.allowPartialSearchResults(), searchRequest.scroll(), nowInMillis, clusterAlias, readerId, keepAlive, ShardSearchRequest.computeWaitForCheckpoint(searchRequest.getWaitForCheckpoints(), shardId, shardRequestIndex), searchRequest.getWaitForCheckpointsTimeout(), searchRequest.isForceSyntheticSource());
        assert (searchRequest.allowPartialSearchResults() != null);
    }

    public static long computeWaitForCheckpoint(Map<String, long[]> indexToWaitForCheckpoints, ShardId shardId, int shardRequestIndex) {
        long waitForCheckpoint;
        long[] waitForCheckpoints = indexToWaitForCheckpoints.getOrDefault(shardId.getIndex().getName(), EMPTY_LONG_ARRAY);
        if (waitForCheckpoints.length == 0) {
            waitForCheckpoint = -2L;
        } else {
            assert (waitForCheckpoints.length > shardRequestIndex);
            waitForCheckpoint = waitForCheckpoints[shardRequestIndex];
        }
        return waitForCheckpoint;
    }

    public ShardSearchRequest(ShardId shardId, long nowInMillis, AliasFilter aliasFilter) {
        this(OriginalIndices.NONE, shardId, -1, -1, SearchType.QUERY_THEN_FETCH, null, null, aliasFilter, 1.0f, true, null, nowInMillis, null, null, null, -2L, SearchService.NO_TIMEOUT, false);
    }

    public ShardSearchRequest(OriginalIndices originalIndices, ShardId shardId, int shardRequestIndex, int numberOfShards, SearchType searchType, SearchSourceBuilder source, Boolean requestCache, AliasFilter aliasFilter, float indexBoost, boolean allowPartialSearchResults, Scroll scroll, long nowInMillis, @Nullable String clusterAlias, ShardSearchContextId readerId, TimeValue keepAlive, long waitForCheckpoint, TimeValue waitForCheckpointsTimeout, boolean forceSyntheticSource) {
        this.shardId = shardId;
        this.shardRequestIndex = shardRequestIndex;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
        this.source(source);
        this.requestCache = requestCache;
        this.aliasFilter = aliasFilter;
        this.indexBoost = indexBoost;
        this.allowPartialSearchResults = allowPartialSearchResults;
        this.scroll = scroll;
        this.nowInMillis = nowInMillis;
        this.clusterAlias = clusterAlias;
        this.originalIndices = originalIndices;
        this.readerId = readerId;
        this.keepAlive = keepAlive;
        assert (keepAlive == null || readerId != null) : "readerId: " + readerId + " keepAlive: " + keepAlive;
        this.channelVersion = TransportVersion.CURRENT;
        this.waitForCheckpoint = waitForCheckpoint;
        this.waitForCheckpointsTimeout = waitForCheckpointsTimeout;
        this.forceSyntheticSource = forceSyntheticSource;
    }

    public ShardSearchRequest(ShardSearchRequest clone) {
        this.shardId = clone.shardId;
        this.shardRequestIndex = clone.shardRequestIndex;
        this.searchType = clone.searchType;
        this.numberOfShards = clone.numberOfShards;
        this.scroll = clone.scroll;
        this.source(clone.source);
        this.aliasFilter = clone.aliasFilter;
        this.indexBoost = clone.indexBoost;
        this.nowInMillis = clone.nowInMillis;
        this.requestCache = clone.requestCache;
        this.clusterAlias = clone.clusterAlias;
        this.allowPartialSearchResults = clone.allowPartialSearchResults;
        this.canReturnNullResponseIfMatchNoDocs = clone.canReturnNullResponseIfMatchNoDocs;
        this.bottomSortValues = clone.bottomSortValues;
        this.originalIndices = clone.originalIndices;
        this.readerId = clone.readerId;
        this.keepAlive = clone.keepAlive;
        this.channelVersion = clone.channelVersion;
        this.waitForCheckpoint = clone.waitForCheckpoint;
        this.waitForCheckpointsTimeout = clone.waitForCheckpointsTimeout;
        this.forceSyntheticSource = clone.forceSyntheticSource;
    }

    public ShardSearchRequest(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        this.shardId = new ShardId(in);
        this.searchType = SearchType.fromId(in.readByte());
        this.shardRequestIndex = in.getTransportVersion().onOrAfter(TransportVersion.V_7_11_0) ? in.readVInt() : -1;
        this.numberOfShards = in.readVInt();
        this.scroll = in.readOptionalWriteable(Scroll::new);
        this.source = in.readOptionalWriteable(SearchSourceBuilder::new);
        if (in.getTransportVersion().before(TransportVersion.V_8_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in search requests but found [" + Arrays.toString(types) + "]");
        }
        this.aliasFilter = AliasFilter.readFrom(in);
        this.indexBoost = in.readFloat();
        this.nowInMillis = in.readVLong();
        this.requestCache = in.readOptionalBoolean();
        this.clusterAlias = in.readOptionalString();
        this.allowPartialSearchResults = in.readBoolean();
        if (in.getTransportVersion().before(TransportVersion.V_7_11_0)) {
            in.readStringArray();
            in.readOptionalString();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_7_7_0)) {
            this.canReturnNullResponseIfMatchNoDocs = in.readBoolean();
            this.bottomSortValues = in.readOptionalWriteable(SearchSortValuesAndFormats::new);
            this.readerId = in.readOptionalWriteable(ShardSearchContextId::new);
            this.keepAlive = in.readOptionalTimeValue();
        } else {
            this.canReturnNullResponseIfMatchNoDocs = false;
            this.bottomSortValues = null;
            this.readerId = null;
            this.keepAlive = null;
        }
        assert (this.keepAlive == null || this.readerId != null) : "readerId: " + this.readerId + " keepAlive: " + this.keepAlive;
        this.channelVersion = TransportVersion.min(TransportVersion.readVersion(in), in.getTransportVersion());
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_7_16_0)) {
            this.waitForCheckpoint = in.readLong();
            this.waitForCheckpointsTimeout = in.readTimeValue();
        } else {
            this.waitForCheckpoint = -2L;
            this.waitForCheckpointsTimeout = SearchService.NO_TIMEOUT;
        }
        this.forceSyntheticSource = in.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0) ? in.readBoolean() : false;
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    protected final void innerWriteTo(StreamOutput out, boolean asKey) throws IOException {
        this.shardId.writeTo(out);
        out.writeByte(this.searchType.id());
        if (!asKey) {
            if (out.getTransportVersion().onOrAfter(TransportVersion.V_7_11_0)) {
                out.writeVInt(this.shardRequestIndex);
            }
            out.writeVInt(this.numberOfShards);
        }
        out.writeOptionalWriteable(this.scroll);
        out.writeOptionalWriteable(this.source);
        if (out.getTransportVersion().before(TransportVersion.V_8_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.aliasFilter.writeTo(out);
        out.writeFloat(this.indexBoost);
        if (!asKey) {
            out.writeVLong(this.nowInMillis);
        }
        out.writeOptionalBoolean(this.requestCache);
        out.writeOptionalString(this.clusterAlias);
        out.writeBoolean(this.allowPartialSearchResults);
        if (!asKey && out.getTransportVersion().before(TransportVersion.V_7_11_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
            out.writeOptionalString(null);
        }
        if (!asKey && out.getTransportVersion().onOrAfter(TransportVersion.V_7_7_0)) {
            out.writeBoolean(this.canReturnNullResponseIfMatchNoDocs);
            out.writeOptionalWriteable(this.bottomSortValues);
            out.writeOptionalWriteable(this.readerId);
            out.writeOptionalTimeValue(this.keepAlive);
        }
        TransportVersion.writeVersion(this.channelVersion, out);
        TransportVersion waitForCheckpointsVersion = TransportVersion.V_7_16_0;
        if (out.getTransportVersion().onOrAfter(waitForCheckpointsVersion)) {
            out.writeLong(this.waitForCheckpoint);
            out.writeTimeValue(this.waitForCheckpointsTimeout);
        } else if (this.waitForCheckpoint != -2L) {
            throw new IllegalArgumentException("Remote node version [" + out.getTransportVersion() + " incompatible with wait_for_checkpoints. All nodes must be version [" + waitForCheckpointsVersion + "] or greater.");
        }
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_4_0)) {
            out.writeBoolean(this.forceSyntheticSource);
        } else if (this.forceSyntheticSource) {
            throw new IllegalArgumentException("force_synthetic_source is not supported before 8.4.0");
        }
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public SearchSourceBuilder source() {
        return this.source;
    }

    public AliasFilter getAliasFilter() {
        return this.aliasFilter;
    }

    public void setAliasFilter(AliasFilter aliasFilter) {
        this.aliasFilter = aliasFilter;
    }

    public void source(SearchSourceBuilder source) {
        if (source != null && source.pointInTimeBuilder() != null) {
            source = source.shallowCopy();
            source.pointInTimeBuilder(new PointInTimeBuilder(""));
        }
        this.source = source;
    }

    public int shardRequestIndex() {
        return this.shardRequestIndex;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public float indexBoost() {
        return this.indexBoost;
    }

    public long nowInMillis() {
        return this.nowInMillis;
    }

    public Boolean requestCache() {
        return this.requestCache;
    }

    public void requestCache(Boolean requestCache) {
        this.requestCache = requestCache;
    }

    public boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public void setBottomSortValues(SearchSortValuesAndFormats values) {
        this.bottomSortValues = values;
    }

    public SearchSortValuesAndFormats getBottomSortValues() {
        return this.bottomSortValues;
    }

    public boolean canReturnNullResponseIfMatchNoDocs() {
        return this.canReturnNullResponseIfMatchNoDocs;
    }

    public void canReturnNullResponseIfMatchNoDocs(boolean value) {
        this.canReturnNullResponseIfMatchNoDocs = value;
    }

    public ShardSearchContextId readerId() {
        return this.readerId;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public long waitForCheckpoint() {
        return this.waitForCheckpoint;
    }

    public TimeValue getWaitForCheckpointsTimeout() {
        return this.waitForCheckpointsTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesReference cacheKey(CheckedBiConsumer<ShardSearchRequest, StreamOutput, IOException> differentiator) throws IOException {
        BytesStreamOutput out = scratch.get();
        try {
            this.innerWriteTo(out, true);
            if (differentiator != null) {
                differentiator.accept(this, out);
            }
            BytesArray bytesArray = new BytesArray(MessageDigests.digest(out.bytes(), MessageDigests.sha256()));
            return bytesArray;
        }
        finally {
            out.reset();
        }
    }

    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchShardTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + this.shardId() + "]";
    }

    public Rewriteable<Rewriteable> getRewriteable() {
        return new RequestRewritable(this);
    }

    public static QueryBuilder parseAliasFilter(CheckedFunction<BytesReference, QueryBuilder, IOException> filterParser, IndexMetadata metadata, String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        Index index = metadata.getIndex();
        Map<String, AliasMetadata> aliases = metadata.getAliases();
        Function<AliasMetadata, QueryBuilder> parserFunction = alias -> {
            if (alias.filter() == null) {
                return null;
            }
            try {
                return (QueryBuilder)filterParser.apply((Object)alias.filter().uncompressed());
            }
            catch (IOException ex) {
                throw new AliasFilterParsingException(index, alias.getAlias(), "Invalid alias filter", ex);
            }
        };
        if (aliasNames.length == 1) {
            AliasMetadata alias2 = aliases.get(aliasNames[0]);
            if (alias2 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return parserFunction.apply(alias2);
        }
        BoolQueryBuilder combined = new BoolQueryBuilder();
        for (String aliasName : aliasNames) {
            AliasMetadata alias3 = aliases.get(aliasName);
            if (alias3 == null) {
                throw new InvalidAliasNameException(index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            QueryBuilder parsedFilter = parserFunction.apply(alias3);
            if (parsedFilter == null) {
                return null;
            }
            combined.should(parsedFilter);
        }
        return combined;
    }

    public final Map<String, Object> getRuntimeMappings() {
        return this.source == null ? Collections.emptyMap() : this.source.runtimeMappings();
    }

    public TransportVersion getChannelVersion() {
        return this.channelVersion;
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    static class RequestRewritable
    implements Rewriteable<Rewriteable> {
        final ShardSearchRequest request;

        RequestRewritable(ShardSearchRequest request) {
            this.request = request;
        }

        @Override
        public Rewriteable rewrite(QueryRewriteContext ctx) throws IOException {
            SearchSourceBuilder newSource = this.request.source() == null ? null : Rewriteable.rewrite(this.request.source(), ctx);
            AliasFilter newAliasFilter = Rewriteable.rewrite(this.request.getAliasFilter(), ctx);
            SearchExecutionContext searchExecutionContext = ctx.convertToSearchExecutionContext();
            FieldSortBuilder primarySort = FieldSortBuilder.getPrimaryFieldSortOrNull(newSource);
            if (searchExecutionContext != null && primarySort != null && primarySort.isBottomSortShardDisjoint(searchExecutionContext, this.request.getBottomSortValues())) {
                assert (newSource != null) : "source should contain a primary sort field";
                newSource = newSource.shallowCopy();
                int trackTotalHitsUpTo = SearchRequest.resolveTrackTotalHitsUpTo(this.request.scroll, this.request.source);
                if (trackTotalHitsUpTo == -1 && newSource.suggest() == null && newSource.aggregations() == null) {
                    newSource.query(new MatchNoneQueryBuilder());
                } else {
                    newSource.size(0);
                }
                this.request.source(newSource);
                this.request.setBottomSortValues(null);
            }
            if (newSource == this.request.source() && newAliasFilter == this.request.getAliasFilter()) {
                return this;
            }
            this.request.source(newSource);
            this.request.setAliasFilter(newAliasFilter);
            return new RequestRewritable(this.request);
        }
    }
}

