/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.DelayedBucket;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.TopBucketBuilder;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractInternalTerms<A extends AbstractInternalTerms<A, B>, B extends AbstractTermsBucket>
extends InternalMultiBucketAggregation<A, B> {
    public AbstractInternalTerms(String name, Map<String, Object> metadata) {
        super(name, metadata);
    }

    protected AbstractInternalTerms(StreamInput in) throws IOException {
        super(in);
    }

    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    protected abstract int getShardSize();

    protected abstract BucketOrder getReduceOrder();

    protected abstract BucketOrder getOrder();

    protected abstract long getSumOfOtherDocCounts();

    protected abstract Long getDocCountError();

    protected abstract void setDocCountError(long var1);

    protected abstract long getMinDocCount();

    protected abstract int getRequiredSize();

    protected abstract B createBucket(long var1, InternalAggregations var3, long var4, B var6);

    @Override
    public B reduceBucket(List<B> buckets, AggregationReduceContext context) {
        assert (buckets.size() > 0);
        long docCount = 0L;
        long docCountError = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (AbstractTermsBucket bucket : buckets) {
            docCount += bucket.getDocCount();
            if (docCountError != -1L) {
                docCountError = !bucket.getShowDocCountError() || bucket.getDocCountError() == -1L ? -1L : (docCountError += bucket.getDocCountError());
            }
            aggregationsList.add((InternalAggregations)bucket.getAggregations());
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(docCount, aggs, docCountError, (AbstractTermsBucket)buckets.get(0));
    }

    private BucketOrder getReduceOrder(List<InternalAggregation> aggregations) {
        BucketOrder thisReduceOrder = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().size() == 0) continue;
            if (thisReduceOrder == null) {
                thisReduceOrder = terms.getReduceOrder();
                continue;
            }
            if (thisReduceOrder.equals(terms.getReduceOrder())) continue;
            return this.getOrder();
        }
        return thisReduceOrder != null ? thisReduceOrder : this.getOrder();
    }

    private long getDocCountError(A terms) {
        int size = ((InternalMultiBucketAggregation)terms).getBuckets().size();
        if (size == 0 || size < ((AbstractInternalTerms)terms).getShardSize() || InternalOrder.isKeyOrder(((AbstractInternalTerms)terms).getOrder())) {
            return 0L;
        }
        if (InternalOrder.isCountDesc(((AbstractInternalTerms)terms).getOrder())) {
            if (((AbstractInternalTerms)terms).getDocCountError() != null) {
                return ((AbstractInternalTerms)terms).getDocCountError();
            }
            return ((InternalMultiBucketAggregation)terms).getBuckets().stream().mapToLong(MultiBucketsAggregation.Bucket::getDocCount).min().getAsLong();
        }
        return -1L;
    }

    private BucketOrder reduceBuckets(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext, Function<DelayedBucket<B>, Boolean> sink) {
        BucketOrder thisReduceOrder = this.getReduceOrder(aggregations);
        if (InternalOrder.isKeyOrder(thisReduceOrder)) {
            thisReduceOrder = InternalOrder.key(InternalOrder.isKeyAsc(thisReduceOrder));
            this.reduceMergeSort(aggregations, thisReduceOrder, reduceContext, sink);
        } else {
            this.reduceLegacy(aggregations, reduceContext, sink);
        }
        return thisReduceOrder;
    }

    private void reduceMergeSort(List<InternalAggregation> aggregations, BucketOrder thisReduceOrder, AggregationReduceContext reduceContext, Function<DelayedBucket<B>, Boolean> sink) {
        assert (InternalOrder.isKeyOrder(thisReduceOrder));
        final Comparator<MultiBucketsAggregation.Bucket> cmp = thisReduceOrder.comparator();
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return cmp.compare(a.current(), b.current()) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            pq.add(new IteratorAndCurrent(terms.getBuckets().iterator()));
        }
        ArrayList<AbstractTermsBucket> sameTermBuckets = new ArrayList<AbstractTermsBucket>();
        AbstractTermsBucket lastBucket = null;
        while (pq.size() > 0) {
            IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
            assert (lastBucket == null || cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0);
            if (lastBucket != null && cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) != 0) {
                boolean shouldContinue = sink.apply(new DelayedBucket<AbstractTermsBucket>((list, aggregationReduceContext) -> this.reduceBucket((List)list, (AggregationReduceContext)aggregationReduceContext), reduceContext, sameTermBuckets));
                if (!shouldContinue) {
                    return;
                }
                sameTermBuckets = new ArrayList();
            }
            lastBucket = (AbstractTermsBucket)top.current();
            sameTermBuckets.add((AbstractTermsBucket)top.current());
            if (top.hasNext()) {
                top.next();
                assert (cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0) : "shards must return data sorted by key";
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (!sameTermBuckets.isEmpty()) {
            sink.apply(new DelayedBucket<AbstractTermsBucket>((list, aggregationReduceContext) -> this.reduceBucket((List)list, (AggregationReduceContext)aggregationReduceContext), reduceContext, sameTermBuckets));
        }
    }

    private void reduceLegacy(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext, Function<DelayedBucket<B>, Boolean> sink) {
        HashMap<Object, List> bucketMap = new HashMap<Object, List>();
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            for (AbstractTermsBucket bucket : terms.getBuckets()) {
                bucketMap.computeIfAbsent(bucket.getKey(), k -> new ArrayList()).add(bucket);
            }
        }
        for (List sameTermBuckets : bucketMap.values()) {
            boolean shouldContinue = sink.apply(new DelayedBucket<AbstractTermsBucket>((list, aggregationReduceContext) -> this.reduceBucket((List)list, (AggregationReduceContext)aggregationReduceContext), reduceContext, sameTermBuckets));
            if (shouldContinue) continue;
            return;
        }
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        List<Object> result;
        BucketOrder thisReduceOrder;
        long sumDocCountError = 0L;
        long[] otherDocCount = new long[]{0L};
        Object referenceTerms = null;
        for (InternalAggregation aggregation : aggregations) {
            AbstractInternalTerms terms = (AbstractInternalTerms)aggregation;
            if (referenceTerms == null && terms.canLeadReduction()) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && terms.canLeadReduction()) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different types in two different indices");
            }
            otherDocCount[0] = otherDocCount[0] + terms.getSumOfOtherDocCounts();
            long l = this.getDocCountError(terms);
            if (sumDocCountError != -1L) {
                sumDocCountError = l == -1L ? -1L : (sumDocCountError += l);
            }
            this.setDocCountError(l);
            for (AbstractTermsBucket bucket2 : terms.getBuckets()) {
                bucket2.updateDocCountError(-l);
            }
        }
        if (reduceContext.isFinalReduce()) {
            TopBucketBuilder top = TopBucketBuilder.build(this.getRequiredSize(), this.getOrder(), removed -> {
                otherDocCount[0] = otherDocCount[0] + removed.getDocCount();
            });
            thisReduceOrder = this.reduceBuckets(aggregations, reduceContext, bucket -> {
                if (bucket.getDocCount() >= this.getMinDocCount()) {
                    top.add(bucket);
                }
                return true;
            });
            result = top.build();
        } else {
            boolean canPrune = InternalOrder.isKeyOrder(this.getOrder()) && this.getMinDocCount() == 0L;
            result = new ArrayList();
            thisReduceOrder = this.reduceBuckets(aggregations, reduceContext, bucket -> {
                result.add((AbstractTermsBucket)bucket.reduced());
                return false == canPrune || result.size() < this.getRequiredSize();
            });
        }
        for (AbstractTermsBucket abstractTermsBucket : result) {
            if (sumDocCountError == -1L) {
                abstractTermsBucket.setDocCountError(-1L);
                continue;
            }
            abstractTermsBucket.updateDocCountError(sumDocCountError);
        }
        long docCountError = sumDocCountError == -1L ? -1L : (aggregations.size() == 1 ? 0L : sumDocCountError);
        return this.create(this.name, result, reduceContext.isFinalReduce() ? this.getOrder() : thisReduceOrder, docCountError, otherDocCount[0]);
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this.create(this.name, this.getBuckets().stream().map(b -> this.createBucket(samplingContext.scaleUp(b.getDocCount()), InternalAggregations.finalizeSampling((InternalAggregations)b.getAggregations(), samplingContext), b.getShowDocCountError() ? samplingContext.scaleUp(b.getDocCountError()) : 0L, b)).toList(), this.getOrder(), samplingContext.scaleUp(this.getDocCountError()), samplingContext.scaleUp(this.getSumOfOtherDocCounts()));
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, Long docCountError, long otherDocCount, List<? extends AbstractTermsBucket> buckets) throws IOException {
        builder.field(InternalTerms.DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), docCountError);
        builder.field(InternalTerms.SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), otherDocCount);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (AbstractTermsBucket abstractTermsBucket : buckets) {
            abstractTermsBucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class AbstractTermsBucket
    extends InternalMultiBucketAggregation.InternalBucket {
        protected abstract void updateDocCountError(long var1);

        protected abstract void setDocCountError(long var1);

        protected abstract boolean getShowDocCountError();

        protected abstract long getDocCountError();
    }
}

