/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.search.sort.SortValue;

public final class InternalAggregations
extends Aggregations
implements Writeable {
    public static final InternalAggregations EMPTY = new InternalAggregations(Collections.emptyList());
    private static final Comparator<InternalAggregation> INTERNAL_AGG_COMPARATOR = (agg1, agg2) -> {
        if (agg1.canLeadReduction() == agg2.canLeadReduction()) {
            return 0;
        }
        if (agg1.canLeadReduction() && !agg2.canLeadReduction()) {
            return -1;
        }
        return 1;
    };

    private InternalAggregations(List<InternalAggregation> aggregations) {
        super(aggregations);
    }

    public static InternalAggregations from(List<InternalAggregation> aggregations) {
        if (aggregations.isEmpty()) {
            return EMPTY;
        }
        return new InternalAggregations(aggregations);
    }

    public static InternalAggregations readFrom(StreamInput in) throws IOException {
        return InternalAggregations.from(in.readList(stream -> stream.readNamedWriteable(InternalAggregation.class)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteableList(this.getInternalAggregations());
    }

    public List<InternalAggregation> copyResults() {
        return new ArrayList<InternalAggregation>(this.getInternalAggregations());
    }

    private List<InternalAggregation> getInternalAggregations() {
        return this.aggregations;
    }

    public SortValue sortValue(AggregationPath.PathElement head, Iterator<AggregationPath.PathElement> tail) {
        InternalAggregation aggregation = (InternalAggregation)this.get(head.name());
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find aggregation named [" + head.name() + "]");
        }
        if (tail.hasNext()) {
            return aggregation.sortValue(tail.next(), tail);
        }
        return aggregation.sortValue(Optional.ofNullable(head.key()).orElse(head.metric()));
    }

    public static InternalAggregations topLevelReduce(List<InternalAggregations> aggregationsList, AggregationReduceContext context) {
        InternalAggregations reduced = InternalAggregations.reduce(aggregationsList, context);
        if (reduced == null) {
            return null;
        }
        if (context.isFinalReduce()) {
            List reducedInternalAggs = reduced.getInternalAggregations();
            reducedInternalAggs = reducedInternalAggs.stream().map(agg -> agg.reducePipelines((InternalAggregation)agg, context, context.pipelineTreeRoot().subTree(agg.getName()))).collect(Collectors.toCollection(ArrayList::new));
            for (PipelineAggregator pipelineAggregator : context.pipelineTreeRoot().aggregators()) {
                SiblingPipelineAggregator sib = (SiblingPipelineAggregator)pipelineAggregator;
                InternalAggregation newAgg = sib.doReduce(InternalAggregations.from(reducedInternalAggs), context);
                reducedInternalAggs.add(newAgg);
            }
            return InternalAggregations.from(reducedInternalAggs);
        }
        return reduced;
    }

    public static InternalAggregations reduce(List<InternalAggregations> aggregationsList, AggregationReduceContext context) {
        if (aggregationsList.isEmpty()) {
            return null;
        }
        HashMap<String, List> aggByName = new HashMap<String, List>();
        for (InternalAggregations aggregations : aggregationsList) {
            for (Aggregation aggregation : aggregations.aggregations) {
                List aggs = aggByName.computeIfAbsent(aggregation.getName(), k -> new ArrayList(aggregationsList.size()));
                aggs.add((InternalAggregation)aggregation);
            }
        }
        ArrayList<InternalAggregation> reducedAggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : aggByName.entrySet()) {
            List aggregations = (List)entry.getValue();
            aggregations.sort(INTERNAL_AGG_COMPARATOR);
            InternalAggregation first = (InternalAggregation)aggregations.get(0);
            if (first.mustReduceOnSingleInternalAgg() || aggregations.size() > 1) {
                reducedAggregations.add(first.reduce(aggregations, context.forAgg((String)entry.getKey())));
                continue;
            }
            reducedAggregations.add(first);
        }
        return InternalAggregations.from(reducedAggregations);
    }

    public static InternalAggregations finalizeSampling(InternalAggregations internalAggregations, SamplingContext samplingContext) {
        return InternalAggregations.from(internalAggregations.aggregations.stream().map(agg -> ((InternalAggregation)agg).finalizeSampling(samplingContext)).collect(Collectors.toList()));
    }
}

