/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field.vectors;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.script.field.vectors.DenseVector;

public class ByteBinaryDenseVector
implements DenseVector {
    public static final int MAGNITUDE_BYTES = 4;
    protected final BytesRef docVector;
    protected final int dims;
    protected float[] floatDocVector;
    protected boolean magnitudeDecoded;
    protected float magnitude;

    public ByteBinaryDenseVector(BytesRef docVector, int dims) {
        this.docVector = docVector;
        this.dims = dims;
    }

    @Override
    public float[] getVector() {
        if (this.floatDocVector == null) {
            this.floatDocVector = new float[this.dims];
            int i = 0;
            int j = this.docVector.offset;
            while (i < this.dims) {
                this.floatDocVector[i++] = this.docVector.bytes[j++];
            }
        }
        return this.floatDocVector;
    }

    @Override
    public float getMagnitude() {
        if (!this.magnitudeDecoded) {
            this.magnitude = ByteBuffer.wrap(this.docVector.bytes, this.docVector.offset + this.dims, 4).getFloat();
            this.magnitudeDecoded = true;
        }
        return this.magnitude;
    }

    @Override
    public int dotProduct(byte[] queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            result += this.docVector.bytes[j++] * queryVector[i++];
        }
        return result;
    }

    @Override
    public double dotProduct(float[] queryVector) {
        throw new UnsupportedOperationException("use [int dotProduct(byte[] queryVector)] instead");
    }

    @Override
    public double dotProduct(List<Number> queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            result += this.docVector.bytes[j++] * queryVector.get(i++).intValue();
        }
        return result;
    }

    @SuppressForbidden(reason="used only for bytes so it cannot overflow")
    private int abs(int value) {
        return Math.abs(value);
    }

    @Override
    public int l1Norm(byte[] queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            result += this.abs(this.docVector.bytes[j++] - queryVector[i++]);
        }
        return result;
    }

    @Override
    public double l1Norm(float[] queryVector) {
        throw new UnsupportedOperationException("use [int l1Norm(byte[] queryVector)] instead");
    }

    @Override
    public double l1Norm(List<Number> queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            result += this.abs(this.docVector.bytes[j++] - queryVector.get(i++).intValue());
        }
        return result;
    }

    @Override
    public double l2Norm(byte[] queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            int diff = this.docVector.bytes[j++] - queryVector[i++];
            result += diff * diff;
        }
        return Math.sqrt(result);
    }

    @Override
    public double l2Norm(float[] queryVector) {
        throw new UnsupportedOperationException("use [double l2Norm(byte[] queryVector)] instead");
    }

    @Override
    public double l2Norm(List<Number> queryVector) {
        int result = 0;
        int i = 0;
        int j = this.docVector.offset;
        while (i < this.dims) {
            int diff = this.docVector.bytes[j++] - queryVector.get(i++).intValue();
            result += diff * diff;
        }
        return Math.sqrt(result);
    }

    @Override
    public double cosineSimilarity(byte[] queryVector, float qvMagnitude) {
        return (float)this.dotProduct(queryVector) / (qvMagnitude * this.getMagnitude());
    }

    @Override
    public double cosineSimilarity(float[] queryVector, boolean normalizeQueryVector) {
        throw new UnsupportedOperationException("use [double cosineSimilarity(byte[] queryVector, float qvMagnitude)] instead");
    }

    @Override
    public double cosineSimilarity(List<Number> queryVector) {
        return this.dotProduct(queryVector) / (double)(DenseVector.getMagnitude(queryVector) * this.getMagnitude());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int getDims() {
        return this.dims;
    }
}

