/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.script.field.NestedDocument;

public class WriteField
implements Field<Object> {
    protected String path;
    protected Supplier<Map<String, Object>> rootSupplier;
    protected Map<String, Object> container;
    protected String leaf;
    private static final Object MISSING = new Object();

    public WriteField(String path, Supplier<Map<String, Object>> rootSupplier) {
        this.path = path;
        this.rootSupplier = rootSupplier;
        this.resolveDepthFlat();
    }

    @Override
    public String getName() {
        return this.path;
    }

    public boolean exists() {
        return this.leaf != null && this.container.containsKey(this.leaf);
    }

    public WriteField move(String path) {
        WriteField dest = new WriteField(path, this.rootSupplier);
        if (!dest.isEmpty()) {
            throw new IllegalArgumentException("Cannot move to non-empty destination [" + path + "]");
        }
        return this.overwrite(path);
    }

    public WriteField move(WriteField path) {
        if (!path.isEmpty()) {
            throw new IllegalArgumentException("Cannot move to non-empty destination [" + path.path + "]");
        }
        return this.overwrite(path);
    }

    public WriteField move(Object path) {
        if (path instanceof String) {
            String str = (String)path;
            return this.move(str);
        }
        if (path instanceof WriteField) {
            WriteField field = (WriteField)path;
            return this.move(field);
        }
        throw new IllegalArgumentException("Cannot call move with [" + path + "], must be String or WriteField, not [" + (path != null ? path.getClass().getName() : "null") + "]");
    }

    public WriteField overwrite(String path) {
        Object value = this.get(MISSING);
        this.remove();
        this.setPath(path);
        if (value == MISSING) {
            this.remove();
        } else {
            this.setLeaf();
            this.set(value);
        }
        return this;
    }

    public WriteField overwrite(WriteField path) {
        Object value = this.get(MISSING);
        this.remove();
        this.setPath(path.path);
        this.rootSupplier = path.rootSupplier;
        if (value == MISSING) {
            this.remove();
        } else {
            this.setLeaf();
            this.set(value);
        }
        path.resolveDepthFlat();
        return this;
    }

    public WriteField overwrite(Object path) {
        if (path instanceof String) {
            String str = (String)path;
            return this.overwrite(str);
        }
        if (path instanceof WriteField) {
            WriteField field = (WriteField)path;
            return this.overwrite(field);
        }
        throw new IllegalArgumentException("Cannot call overwrite with [" + path + "], must be String or WriteField, not [" + (path != null ? path.getClass().getName() : "null") + "]");
    }

    public void remove() {
        this.resolveDepthFlat();
        if (this.leaf == null) {
            return;
        }
        this.container.remove(this.leaf);
    }

    public WriteField set(Object value) {
        this.setLeaf();
        if (value instanceof NestedDocument) {
            NestedDocument doc = (NestedDocument)value;
            throw new IllegalArgumentException("cannot set NestedDocument [" + doc.getDoc() + "] as path [" + this.path + "]");
        }
        this.container.put(this.leaf, value);
        return this;
    }

    public WriteField append(Object value) {
        this.setLeaf();
        this.container.compute(this.leaf, (k, v) -> {
            List<Object> values;
            if (v == null) {
                values = new ArrayList(4);
            } else if (v instanceof List) {
                List list = (List)v;
                values = list;
            } else {
                values = new ArrayList(4);
                values.add(v);
            }
            if (value instanceof NestedDocument) {
                NestedDocument doc = (NestedDocument)value;
                throw new IllegalArgumentException("cannot append NestedDocument [" + doc.getDoc() + "] to path [" + this.path + "]");
            }
            values.add(value);
            return values;
        });
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.leaf == null) {
            return 0;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return 0;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.size();
        }
        return 1;
    }

    @Override
    public Iterator<Object> iterator() {
        if (this.leaf == null) {
            return Collections.emptyIterator();
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return Collections.emptyIterator();
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.iterator();
        }
        return Collections.singleton(value).iterator();
    }

    public Object get(Object defaultValue) {
        if (this.leaf == null) {
            return defaultValue;
        }
        return this.container.getOrDefault(this.leaf, defaultValue);
    }

    public Object get(int index, Object defaultValue) {
        if (this.leaf == null) {
            return defaultValue;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value instanceof List) {
            List list = (List)value;
            if (index < list.size()) {
                return list.get(index);
            }
        } else if (value != MISSING && index == 0) {
            return value;
        }
        return defaultValue;
    }

    public boolean hasValue(Predicate<Object> predicate) {
        if (this.leaf == null) {
            return false;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return false;
        }
        if (value instanceof List) {
            List list = (List)value;
            return list.stream().anyMatch(predicate);
        }
        return predicate.test(value);
    }

    public WriteField transform(Function<Object, Object> transformer) {
        if (this.leaf == null) {
            return this;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return this;
        }
        if (value instanceof List) {
            List list = (List)value;
            list.replaceAll(transformer::apply);
        } else {
            this.container.put(this.leaf, transformer.apply(value));
        }
        return this;
    }

    public WriteField deduplicate() {
        if (this.leaf == null) {
            return this;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return this;
        }
        if (value instanceof List) {
            List list = (List)value;
            HashSet set = new HashSet(list);
            list.clear();
            list.addAll(set);
        }
        return this;
    }

    public WriteField removeValuesIf(Predicate<Object> filter) {
        if (this.leaf == null) {
            return this;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return this;
        }
        if (value instanceof List) {
            List list = (List)value;
            list.removeIf(filter);
        } else if (filter.test(value)) {
            this.container.remove(this.leaf);
        }
        return this;
    }

    public WriteField removeValue(int index) {
        if (this.leaf == null) {
            return this;
        }
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return this;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (index < list.size()) {
                list.remove(index);
            }
        } else if (index == 0) {
            this.container.remove(this.leaf);
        }
        return this;
    }

    void remove(Object o) {
        Object value = this.container.getOrDefault(this.leaf, MISSING);
        if (value == MISSING) {
            return;
        }
        if (value instanceof List) {
            List list = (List)value;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                if (it.next() != o) continue;
                it.remove();
                return;
            }
        } else if (this.container.get(this.leaf) == value) {
            this.container.remove(this.leaf);
        }
    }

    public NestedDocument doc() {
        List<Map<String, Object>> docs = this.getDocsAsList();
        if (docs == null) {
            NestedDocument doc = new NestedDocument(this, new HashMap<String, Object>());
            this.set(doc.getDoc());
            return doc;
        }
        NestedDocument doc = new NestedDocument(this, new HashMap<String, Object>());
        docs.add(doc.getDoc());
        return doc;
    }

    public NestedDocument doc(int index) {
        List<Map<String, Object>> docs = this.getDocsAsList();
        if (docs == null) {
            if (index == 0) {
                NestedDocument doc = new NestedDocument(this, new HashMap<String, Object>());
                this.set(doc.getDoc());
                return doc;
            }
            docs = new ArrayList<Map<String, Object>>(index + 1);
            this.set(docs);
        }
        if (index < docs.size()) {
            return new NestedDocument(this, docs.get(index));
        }
        for (int i = docs.size(); i < index; ++i) {
            docs.add(new HashMap());
        }
        NestedDocument doc = new NestedDocument(this, new HashMap<String, Object>());
        docs.add(doc.getDoc());
        return doc;
    }

    protected List<Map<String, Object>> getDocsAsList() {
        ArrayList<Map> docs;
        Object value = this.get(MISSING);
        if (value == MISSING) {
            return null;
        }
        if (value instanceof List) {
            ArrayList<Map> list;
            docs = list = (ArrayList<Map>)value;
        } else if (value instanceof Map) {
            Map map = (Map)value;
            docs = new ArrayList<Map>(4);
            docs.add(map);
            this.set(docs);
        } else {
            throw new IllegalStateException("Unexpected value [" + value + "] of type [" + this.typeName(value) + "] at path [" + this.path + "], expected Map or List of Map");
        }
        return docs;
    }

    public Iterable<NestedDocument> docs() {
        Object value = this.get(MISSING);
        if (value == MISSING) {
            return Collections.emptyList();
        }
        if (value instanceof Map) {
            final Map map = (Map)value;
            return () -> new Iterator<NestedDocument>(){
                private boolean done = false;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public NestedDocument next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return new NestedDocument(WriteField.this, map);
                }

                @Override
                public void remove() {
                    WriteField.this.remove();
                }
            };
        }
        if (value instanceof List) {
            final List list = (List)value;
            return () -> new Iterator<NestedDocument>(){
                private final Iterator<?> it;
                private int index;
                {
                    this.it = list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public NestedDocument next() {
                    Object value = this.it.next();
                    if (value instanceof Map) {
                        Map map = (Map)value;
                        ++this.index;
                        return new NestedDocument(WriteField.this, map);
                    }
                    throw new IllegalStateException("Unexpected value [" + value + "] of type [" + WriteField.this.typeName(value) + "] at [" + WriteField.this.path + "] and index [" + this.index + "] for docs() iterator");
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
        throw new IllegalStateException("Unexpected value [" + value + "] of type [" + this.typeName(value) + "] at [" + this.path + "] for docs()");
    }

    protected void setPath(String path) {
        this.path = path;
        this.leaf = null;
        this.container = null;
    }

    protected void setLeaf() {
        if (this.leaf == null) {
            this.resolveDepthFlat();
        }
        if (this.leaf == null) {
            this.createDepth();
        }
    }

    protected void resolveDepthFlat() {
        this.container = this.rootSupplier.get();
        int index = this.path.indexOf(46);
        int lastIndex = 0;
        while (index != -1) {
            String segment = this.path.substring(lastIndex, index);
            Object value = this.container.get(segment);
            if (value instanceof Map) {
                Map map;
                this.container = map = (Map)value;
                lastIndex = index + 1;
                index = this.path.indexOf(46, lastIndex);
                continue;
            }
            String rest = this.path.substring(lastIndex);
            this.leaf = this.container.containsKey(rest) ? rest : null;
            return;
        }
        this.leaf = this.path.substring(lastIndex);
    }

    protected void createDepth() {
        this.container = this.rootSupplier.get();
        String[] segments = this.path.split("\\.");
        for (int i = 0; i < segments.length - 1; ++i) {
            String segment = segments[i];
            Object value = this.container.getOrDefault(segment, MISSING);
            if (value instanceof Map) {
                Map map;
                this.container = map = (Map)value;
                continue;
            }
            if (value == MISSING) {
                Map next = Maps.newHashMapWithExpectedSize(4);
                this.container.put(segment, next);
                this.container = next;
                continue;
            }
            throw new IllegalArgumentException("Segment [" + i + ":'" + segment + "'] has value [" + value + "] of type [" + this.typeName(value) + "]");
        }
        this.leaf = segments[segments.length - 1];
    }

    protected String typeName(Object value) {
        return value != null ? value.getClass().getName() : "null";
    }
}

