/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.script.TimeSeries;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class ScriptContextStats
implements Writeable,
ToXContentFragment,
Comparable<ScriptContextStats> {
    private final String context;
    private final long compilations;
    private final TimeSeries compilationsHistory;
    private final long cacheEvictions;
    private final TimeSeries cacheEvictionsHistory;
    private final long compilationLimitTriggered;

    public ScriptContextStats(String context, long compilationLimitTriggered, TimeSeries compilationsHistory, TimeSeries cacheEvictionsHistory) {
        this.context = Objects.requireNonNull(context);
        this.compilations = compilationsHistory.total;
        this.cacheEvictions = cacheEvictionsHistory.total;
        this.compilationLimitTriggered = compilationLimitTriggered;
        this.compilationsHistory = compilationsHistory;
        this.cacheEvictionsHistory = cacheEvictionsHistory;
    }

    public ScriptContextStats(StreamInput in) throws IOException {
        this.context = in.readString();
        this.compilations = in.readVLong();
        this.cacheEvictions = in.readVLong();
        this.compilationLimitTriggered = in.readVLong();
        if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_1_0)) {
            this.compilationsHistory = new TimeSeries(in);
            this.cacheEvictionsHistory = new TimeSeries(in);
        } else if (in.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
            this.compilationsHistory = new TimeSeries(in).withTotal(this.compilations);
            this.cacheEvictionsHistory = new TimeSeries(in).withTotal(this.cacheEvictions);
        } else {
            this.compilationsHistory = new TimeSeries(this.compilations);
            this.cacheEvictionsHistory = new TimeSeries(this.cacheEvictions);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.context);
        out.writeVLong(this.compilations);
        out.writeVLong(this.cacheEvictions);
        out.writeVLong(this.compilationLimitTriggered);
        if (out.getTransportVersion().onOrAfter(TransportVersion.V_8_0_0)) {
            this.compilationsHistory.writeTo(out);
            this.cacheEvictionsHistory.writeTo(out);
        }
    }

    public String getContext() {
        return this.context;
    }

    public long getCompilations() {
        return this.compilations;
    }

    public TimeSeries getCompilationsHistory() {
        return this.compilationsHistory;
    }

    public long getCacheEvictions() {
        return this.cacheEvictions;
    }

    public TimeSeries getCacheEvictionsHistory() {
        return this.cacheEvictionsHistory;
    }

    public long getCompilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("context", this.getContext());
        builder.field("compilations", this.getCompilations());
        TimeSeries series = this.getCompilationsHistory();
        if (series != null && !series.areTimingsEmpty()) {
            builder.startObject("compilations_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("cache_evictions", this.getCacheEvictions());
        series = this.getCacheEvictionsHistory();
        if (series != null && !series.areTimingsEmpty()) {
            builder.startObject("cache_evictions_history");
            series.toXContent(builder, params);
            builder.endObject();
        }
        builder.field("compilation_limit_triggered", this.getCompilationLimitTriggered());
        builder.endObject();
        return builder;
    }

    @Override
    public int compareTo(ScriptContextStats o) {
        return this.context.compareTo(o.context);
    }

    static final class Fields {
        static final String CONTEXT = "context";
        static final String COMPILATIONS = "compilations";
        static final String COMPILATIONS_HISTORY = "compilations_history";
        static final String CACHE_EVICTIONS = "cache_evictions";
        static final String CACHE_EVICTIONS_HISTORY = "cache_evictions_history";
        static final String COMPILATION_LIMIT_TRIGGERED = "compilation_limit_triggered";
        static final String FIVE_MINUTES = "5m";
        static final String FIFTEEN_MINUTES = "15m";
        static final String TWENTY_FOUR_HOURS = "24h";

        Fields() {
        }
    }
}

