/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.node.ReportingService;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.ModuleSupport;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginApiInfo;
import org.elasticsearch.plugins.PluginBundle;
import org.elasticsearch.plugins.PluginDescriptor;
import org.elasticsearch.plugins.PluginIntrospector;
import org.elasticsearch.plugins.PluginLoaderIndirection;
import org.elasticsearch.plugins.PluginRuntimeInfo;
import org.elasticsearch.plugins.PluginsUtils;
import org.elasticsearch.plugins.StablePluginPlaceHolder;
import org.elasticsearch.plugins.UberModuleClassLoader;
import org.elasticsearch.plugins.scanners.StablePluginsRegistry;
import org.elasticsearch.plugins.spi.SPIClassIterator;

public class PluginsService
implements ReportingService<PluginsAndModules> {
    private static final Logger logger = LogManager.getLogger(PluginsService.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(PluginsService.class);
    private final Settings settings;
    private final Path configPath;
    private final List<LoadedPlugin> plugins;
    private final PluginsAndModules info;
    private final StablePluginsRegistry stablePluginsRegistry = new StablePluginsRegistry();
    public static final Setting<List<String>> MANDATORY_SETTING = Setting.listSetting("plugin.mandatory", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private static final Module serverModule = PluginsService.class.getModule();

    public StablePluginsRegistry getStablePluginRegistry() {
        return this.stablePluginsRegistry;
    }

    public PluginsService(Settings settings, Path configPath, Path modulesDirectory, Path pluginsDirectory) {
        this.settings = settings;
        this.configPath = configPath;
        LinkedHashSet<PluginBundle> seenBundles = new LinkedHashSet<PluginBundle>();
        ArrayList<PluginDescriptor> modulesList = new ArrayList<PluginDescriptor>();
        if (modulesDirectory != null) {
            try {
                Set<PluginBundle> modules = PluginsUtils.getModuleBundles(modulesDirectory);
                modules.stream().map(PluginBundle::pluginDescriptor).forEach(modulesList::add);
                seenBundles.addAll(modules);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize modules", ex);
            }
        }
        ArrayList<PluginDescriptor> pluginsList = new ArrayList<PluginDescriptor>();
        if (pluginsDirectory != null) {
            try {
                if (FileSystemUtils.isAccessibleDirectory(pluginsDirectory, logger)) {
                    PluginsUtils.checkForFailedPluginRemovals(pluginsDirectory);
                    Set<PluginBundle> plugins = PluginsUtils.getPluginBundles(pluginsDirectory);
                    plugins.stream().map(PluginBundle::pluginDescriptor).forEach(pluginsList::add);
                    seenBundles.addAll(plugins);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to initialize plugins", ex);
            }
        }
        LinkedHashMap<String, LoadedPlugin> loadedPlugins = this.loadBundles(seenBundles);
        PluginIntrospector inspector = PluginIntrospector.getInstance();
        this.info = new PluginsAndModules(PluginsService.getRuntimeInfos(inspector, pluginsList, loadedPlugins), modulesList);
        this.plugins = List.copyOf(loadedPlugins.values());
        PluginsService.checkDeprecations(inspector, pluginsList, loadedPlugins);
        PluginsService.checkMandatoryPlugins(pluginsList.stream().map(PluginDescriptor::getName).collect(Collectors.toSet()), new HashSet<String>((Collection)MANDATORY_SETTING.get(settings)));
        PluginsService.logPluginInfo(this.info.getModuleInfos(), "module", logger);
        PluginsService.logPluginInfo(pluginsList, "plugin", logger);
    }

    static void checkMandatoryPlugins(Set<String> existingPlugins, Set<String> mandatoryPlugins) {
        if (mandatoryPlugins.isEmpty()) {
            return;
        }
        Set<String> missingPlugins = Sets.difference(mandatoryPlugins, existingPlugins);
        if (!missingPlugins.isEmpty()) {
            String message = "missing mandatory plugins [" + String.join((CharSequence)", ", missingPlugins) + "], found plugins [" + String.join((CharSequence)", ", existingPlugins) + "]";
            throw new IllegalStateException(message);
        }
    }

    private static void logPluginInfo(List<PluginDescriptor> pluginDescriptors, String type, Logger logger) {
        assert (pluginDescriptors != null);
        if (pluginDescriptors.isEmpty()) {
            logger.info("no " + type + "s loaded");
        } else {
            for (String name : pluginDescriptors.stream().map(PluginDescriptor::getName).sorted().toList()) {
                logger.info("loaded " + type + " [" + name + "]");
            }
        }
    }

    private static List<PluginRuntimeInfo> getRuntimeInfos(PluginIntrospector inspector, List<PluginDescriptor> pluginDescriptors, Map<String, LoadedPlugin> plugins) {
        Set<String> officialPlugins = PluginsService.getOfficialPlugins();
        ArrayList<PluginRuntimeInfo> runtimeInfos = new ArrayList<PluginRuntimeInfo>();
        for (PluginDescriptor descriptor : pluginDescriptors) {
            LoadedPlugin plugin = plugins.get(descriptor.getName());
            assert (plugin != null);
            Class<?> pluginClazz = plugin.instance.getClass();
            boolean isOfficial = officialPlugins.contains(descriptor.getName());
            PluginApiInfo apiInfo = null;
            if (!isOfficial) {
                apiInfo = new PluginApiInfo(inspector.interfaces(pluginClazz), inspector.overriddenMethods(pluginClazz));
            }
            runtimeInfos.add(new PluginRuntimeInfo(descriptor, isOfficial, apiInfo));
        }
        return runtimeInfos;
    }

    private static Set<String> getOfficialPlugins() {
        Set set;
        block8: {
            InputStream stream = PluginsService.class.getResourceAsStream("/plugins.txt");
            try {
                set = Streams.readAllLines(stream).stream().map(String::trim).collect(Sets.toUnmodifiableSortedSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return set;
    }

    public final <T> Stream<T> map(Function<Plugin, T> function) {
        return this.plugins().stream().map(LoadedPlugin::instance).map(function);
    }

    public final <T> Stream<T> flatMap(Function<Plugin, Collection<T>> function) {
        return this.plugins().stream().map(LoadedPlugin::instance).flatMap((? super T p) -> ((Collection)function.apply((Plugin)p)).stream());
    }

    public final void forEach(Consumer<Plugin> consumer) {
        this.plugins().stream().map(LoadedPlugin::instance).forEach(consumer);
    }

    public final Map<String, Plugin> pluginMap() {
        return this.plugins().stream().collect(Collectors.toMap(p -> p.descriptor().getName(), LoadedPlugin::instance));
    }

    @Override
    public PluginsAndModules info() {
        return this.info;
    }

    protected List<LoadedPlugin> plugins() {
        return this.plugins;
    }

    private LinkedHashMap<String, LoadedPlugin> loadBundles(Set<PluginBundle> bundles) {
        LinkedHashMap<String, LoadedPlugin> loaded = new LinkedHashMap<String, LoadedPlugin>();
        HashMap<String, Set<URL>> transitiveUrls = new HashMap<String, Set<URL>>();
        List<PluginBundle> sortedBundles = PluginsUtils.sortBundles(bundles);
        Set systemLoaderURLs = JarHell.parseModulesAndClassPath();
        for (PluginBundle bundle : sortedBundles) {
            PluginsUtils.checkBundleJarHell(systemLoaderURLs, bundle, transitiveUrls);
            this.loadBundle(bundle, loaded);
        }
        PluginsService.loadExtensions(loaded.values());
        return loaded;
    }

    static void loadExtensions(Collection<LoadedPlugin> plugins) {
        Map extendingPluginsByName = plugins.stream().flatMap((? super T t) -> t.descriptor().getExtendedPlugins().stream().map((? super T extendedPlugin) -> Tuple.tuple((Object)extendedPlugin, (Object)t.instance()))).collect(Collectors.groupingBy(Tuple::v1, Collectors.mapping(Tuple::v2, Collectors.toList())));
        for (LoadedPlugin pluginTuple : plugins) {
            if (!(pluginTuple.instance() instanceof ExtensiblePlugin)) continue;
            PluginsService.loadExtensionsForPlugin((ExtensiblePlugin)((Object)pluginTuple.instance()), extendingPluginsByName.getOrDefault(pluginTuple.descriptor().getName(), List.of()));
        }
    }

    public <T> List<? extends T> loadServiceProviders(Class<T> service) {
        ArrayList<T> result = new ArrayList<T>();
        for (LoadedPlugin pluginTuple : this.plugins()) {
            result.addAll(PluginsService.createExtensions(service, pluginTuple.instance));
        }
        return Collections.unmodifiableList(result);
    }

    private static void loadExtensionsForPlugin(ExtensiblePlugin extensiblePlugin, final List<Plugin> extendingPlugins) {
        ExtensiblePlugin.ExtensionLoader extensionLoader = new ExtensiblePlugin.ExtensionLoader(){

            @Override
            public <T> List<T> loadExtensions(Class<T> extensionPointType) {
                ArrayList<T> result = new ArrayList<T>();
                for (Plugin extendingPlugin : extendingPlugins) {
                    result.addAll(PluginsService.createExtensions(extensionPointType, extendingPlugin));
                }
                return Collections.unmodifiableList(result);
            }
        };
        extensiblePlugin.loadExtensions(extensionLoader);
    }

    private static <T> List<? extends T> createExtensions(Class<T> extensionPointType, Plugin plugin) {
        SPIClassIterator<T> classIterator = SPIClassIterator.get(extensionPointType, plugin.getClass().getClassLoader());
        ArrayList<T> extensions = new ArrayList<T>();
        while (classIterator.hasNext()) {
            Object extensionClass = classIterator.next();
            extensions.add(PluginsService.createExtension(extensionClass, extensionPointType, plugin));
        }
        return extensions;
    }

    static <T> T createExtension(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        Constructor<?>[] constructors = extensionClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        Constructor<?> constructor = constructors[0];
        if (constructors.length == 2) {
            if (constructors[1].getParameterCount() > 0) {
                constructor = constructors[1];
            }
        } else if (constructors.length > 1) {
            throw new IllegalStateException("no unique public " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType));
        }
        if (constructor.getParameterCount() > 1) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin));
        }
        if (constructor.getParameterCount() == 1 && constructor.getParameterTypes()[0] != plugin.getClass()) {
            throw new IllegalStateException(PluginsService.extensionSignatureMessage(extensionClass, extensionPointType, plugin) + ", not (" + constructor.getParameterTypes()[0].getName() + ")");
        }
        try {
            if (constructor.getParameterCount() == 0) {
                return (T)constructor.newInstance(new Object[0]);
            }
            return (T)constructor.newInstance(plugin);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to create extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]", e);
        }
    }

    private static <T> String extensionSignatureMessage(Class<? extends T> extensionClass, Class<T> extensionPointType, Plugin plugin) {
        return "signature of " + PluginsService.extensionConstructorMessage(extensionClass, extensionPointType) + " must be either () or (" + plugin.getClass().getName() + ")";
    }

    private static <T> String extensionConstructorMessage(Class<? extends T> extensionClass, Class<T> extensionPointType) {
        return "constructor for extension [" + extensionClass.getName() + "] of type [" + extensionPointType.getName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBundle(PluginBundle bundle, Map<String, LoadedPlugin> loaded) {
        String name = bundle.plugin.getName();
        logger.debug(() -> "Loading bundle: " + name);
        PluginsUtils.verifyCompatibility(bundle.plugin);
        ArrayList<LoadedPlugin> extendedPlugins = new ArrayList<LoadedPlugin>();
        for (String extendedPluginName : bundle.plugin.getExtendedPlugins()) {
            LoadedPlugin extendedPlugin = loaded.get(extendedPluginName);
            assert (extendedPlugin != null);
            if (!ExtensiblePlugin.class.isInstance(extendedPlugin.instance())) {
                throw new IllegalStateException("Plugin [" + name + "] cannot extend non-extensible plugin [" + extendedPluginName + "]");
            }
            assert (extendedPlugin.loader() != null) : "All non-classpath plugins should be loaded with a classloader";
            extendedPlugins.add(extendedPlugin);
            logger.debug(() -> "Loading bundle: " + name + ", ext plugins: " + extendedPlugins.stream().map((? super T lp) -> lp.descriptor().getName()).toList());
        }
        ClassLoader parentLoader = PluginLoaderIndirection.createLoader(this.getClass().getClassLoader(), extendedPlugins.stream().map(LoadedPlugin::loader).toList());
        LayerAndLoader spiLayerAndLoader = null;
        if (bundle.hasSPI()) {
            spiLayerAndLoader = PluginsService.createSPI(bundle, parentLoader, extendedPlugins);
        }
        ClassLoader pluginParentLoader = spiLayerAndLoader == null ? parentLoader : spiLayerAndLoader.loader();
        LayerAndLoader pluginLayerAndLoader = PluginsService.createPlugin(bundle, pluginParentLoader, extendedPlugins, spiLayerAndLoader);
        ClassLoader pluginClassLoader = pluginLayerAndLoader.loader();
        if (spiLayerAndLoader == null) {
            spiLayerAndLoader = pluginLayerAndLoader;
        }
        PluginsService.reloadLuceneSPI(pluginClassLoader);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Plugin plugin;
            PluginsService.privilegedSetContextClassLoader(pluginClassLoader);
            if (bundle.pluginDescriptor().isStable()) {
                this.stablePluginsRegistry.scanBundleForStablePlugins(bundle, pluginClassLoader);
                plugin = new StablePluginPlaceHolder(bundle.plugin.getName());
            } else {
                Class<? extends Plugin> pluginClass = PluginsService.loadPluginClass(bundle.plugin.getClassname(), pluginClassLoader);
                if (pluginClassLoader != pluginClass.getClassLoader()) {
                    throw new IllegalStateException("Plugin [" + name + "] must reference a class loader local Plugin class [" + bundle.plugin.getClassname() + "] (class loader [" + pluginClass.getClassLoader() + "])");
                }
                plugin = PluginsService.loadPlugin(pluginClass, this.settings, this.configPath);
            }
            loaded.put(name, new LoadedPlugin(bundle.plugin, plugin, spiLayerAndLoader.loader(), spiLayerAndLoader.layer()));
        }
        finally {
            PluginsService.privilegedSetContextClassLoader(cl);
        }
    }

    static LayerAndLoader createSPI(PluginBundle bundle, ClassLoader parentLoader, List<LoadedPlugin> extendedPlugins) {
        PluginDescriptor plugin = bundle.plugin;
        if (plugin.getModuleName().isPresent()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", creating spi, modular");
            return PluginsService.createSpiModuleLayer(bundle.spiUrls, parentLoader, extendedPlugins.stream().map(LoadedPlugin::layer).toList());
        }
        logger.debug(() -> "Loading bundle: " + plugin.getName() + ", creating spi, non-modular");
        return LayerAndLoader.ofLoader(URLClassLoader.newInstance(bundle.spiUrls.toArray(new URL[0]), parentLoader));
    }

    static LayerAndLoader createPlugin(PluginBundle bundle, ClassLoader pluginParentLoader, List<LoadedPlugin> extendedPlugins, LayerAndLoader spiLayerAndLoader) {
        PluginDescriptor plugin = bundle.plugin;
        if (plugin.getModuleName().isPresent()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", modular");
            List<ModuleLayer> parentLayers = Stream.concat(Stream.ofNullable(spiLayerAndLoader != null ? spiLayerAndLoader.layer() : null), extendedPlugins.stream().map(LoadedPlugin::layer)).toList();
            return PluginsService.createPluginModuleLayer(bundle, pluginParentLoader, parentLayers);
        }
        if (plugin.isStable()) {
            logger.debug(() -> "Loading bundle: " + plugin.getName() + ", non-modular as synthetic module");
            return LayerAndLoader.ofLoader(UberModuleClassLoader.getInstance(pluginParentLoader, ModuleLayer.boot(), "synthetic." + PluginsService.toModuleName(plugin.getName()), bundle.allUrls, Set.of("org.elasticsearch.server")));
        }
        logger.debug(() -> "Loading bundle: " + plugin.getName() + ", non-modular");
        return LayerAndLoader.ofLoader(URLClassLoader.newInstance((URL[])bundle.urls.toArray(URL[]::new), pluginParentLoader));
    }

    static String toModuleName(String name) {
        String result = name.replaceAll("\\W+", ".").replaceAll("(^[^A-Za-z_]*)", "").replaceAll("\\.$", "").toLowerCase(Locale.getDefault());
        assert (ModuleSupport.isPackageName(result));
        return result;
    }

    private static void checkDeprecations(PluginIntrospector inspector, List<PluginDescriptor> pluginDescriptors, Map<String, LoadedPlugin> plugins) {
        for (PluginDescriptor descriptor : pluginDescriptors) {
            LoadedPlugin plugin = plugins.get(descriptor.getName());
            Class<?> pluginClazz = plugin.instance.getClass();
            for (String string : inspector.deprecatedInterfaces(pluginClazz)) {
                deprecationLogger.warn(DeprecationCategory.PLUGINS, pluginClazz.getName() + string, "Plugin class {} from plugin {} implements deprecated plugin interface {}. This plugin interface will be removed in a future release.", pluginClazz.getName(), descriptor.getName(), string);
            }
            for (Map.Entry entry : inspector.deprecatedMethods(pluginClazz).entrySet()) {
                String methodName = (String)entry.getKey();
                String interfaceName = (String)entry.getValue();
                deprecationLogger.warn(DeprecationCategory.PLUGINS, pluginClazz.getName() + methodName + interfaceName, "Plugin class {} from plugin {} implements deprecated method {} from plugin interface {}. This method will be removed in a future release.", pluginClazz.getName(), descriptor.getName(), methodName, interfaceName);
            }
        }
    }

    static void reloadLuceneSPI(ClassLoader loader) {
        PostingsFormat.reloadPostingsFormats((ClassLoader)loader);
        DocValuesFormat.reloadDocValuesFormats((ClassLoader)loader);
        Codec.reloadCodecs((ClassLoader)loader);
    }

    private static Class<? extends Plugin> loadPluginClass(String className, ClassLoader loader) {
        try {
            return Class.forName(className, false, loader).asSubclass(Plugin.class);
        }
        catch (ClassNotFoundException e) {
            throw new ElasticsearchException("Could not find plugin class [" + className + "]", (Throwable)e, new Object[0]);
        }
    }

    static Plugin loadPlugin(Class<? extends Plugin> pluginClass, Settings settings, Path configPath) {
        Constructor<?>[] constructors = pluginClass.getConstructors();
        if (constructors.length == 0) {
            throw new IllegalStateException("no public constructor for [" + pluginClass.getName() + "]");
        }
        if (constructors.length > 1) {
            throw new IllegalStateException("no unique public constructor for [" + pluginClass.getName() + "]");
        }
        Constructor<?> constructor = constructors[0];
        if (constructor.getParameterCount() > 2) {
            throw new IllegalStateException(PluginsService.signatureMessage(pluginClass));
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        try {
            if (constructor.getParameterCount() == 2 && parameterTypes[0] == Settings.class && parameterTypes[1] == Path.class) {
                return (Plugin)constructor.newInstance(settings, configPath);
            }
            if (constructor.getParameterCount() == 1 && parameterTypes[0] == Settings.class) {
                return (Plugin)constructor.newInstance(settings);
            }
            if (constructor.getParameterCount() == 0) {
                return (Plugin)constructor.newInstance(new Object[0]);
            }
            throw new IllegalStateException(PluginsService.signatureMessage(pluginClass));
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("failed to load plugin class [" + pluginClass.getName() + "]", e);
        }
    }

    private static String signatureMessage(Class<? extends Plugin> clazz) {
        return String.format(Locale.ROOT, "no public constructor of correct signature for [%s]; must be [%s], [%s], or [%s]", clazz.getName(), "(org.elasticsearch.common.settings.Settings,java.nio.file.Path)", "(org.elasticsearch.common.settings.Settings)", "()");
    }

    public final <T> List<T> filterPlugins(Class<T> type) {
        return this.plugins().stream().filter(x -> type.isAssignableFrom(x.instance().getClass())).map((? super T p) -> p.instance()).toList();
    }

    public static Function<Settings, PluginsService> getPluginsServiceCtor(Environment environment) {
        return settings -> new PluginsService((Settings)settings, environment.configFile(), environment.modulesFile(), environment.pluginsFile());
    }

    static final LayerAndLoader createPluginModuleLayer(PluginBundle bundle, ClassLoader parentLoader, List<ModuleLayer> parentLayers) {
        assert (bundle.plugin.getModuleName().isPresent());
        return PluginsService.createModuleLayer(bundle.plugin.getClassname(), bundle.plugin.getModuleName().get(), PluginsService.urlsToPaths(bundle.urls), parentLoader, parentLayers);
    }

    static final LayerAndLoader createSpiModuleLayer(Set<URL> urls, ClassLoader parentLoader, List<ModuleLayer> parentLayers) {
        return PluginsService.createModuleLayer(null, PluginsService.spiModuleName(urls), PluginsService.urlsToPaths(urls), parentLoader, parentLayers);
    }

    static final LayerAndLoader createModuleLayer(String className, String moduleName, Path[] paths, ClassLoader parentLoader, List<ModuleLayer> parentLayers) {
        logger.debug(() -> "Loading bundle: creating module layer and loader for module " + moduleName);
        ModuleFinder finder = ModuleFinder.of(paths);
        Configuration configuration = Configuration.resolveAndBind(ModuleFinder.of(new Path[0]), PluginsService.parentConfigurationOrBoot(parentLayers), finder, Set.of(moduleName));
        ModuleLayer.Controller controller = PluginsService.privilegedDefineModulesWithOneLoader(configuration, PluginsService.parentLayersOrBoot(parentLayers), parentLoader);
        Module pluginModule = controller.layer().findModule(moduleName).get();
        PluginsService.ensureEntryPointAccessible(controller, pluginModule, className);
        PluginsService.addQualifiedExports(pluginModule);
        PluginsService.addQualifiedOpens(pluginModule);
        logger.debug(() -> "Loading bundle: created module layer and loader for module " + moduleName);
        return new LayerAndLoader(controller.layer(), PluginsService.privilegedFindLoader(controller.layer(), moduleName));
    }

    private static List<ModuleLayer> parentLayersOrBoot(List<ModuleLayer> parentLayers) {
        if (parentLayers == null || parentLayers.isEmpty()) {
            return List.of(ModuleLayer.boot());
        }
        return parentLayers;
    }

    private static List<Configuration> parentConfigurationOrBoot(List<ModuleLayer> parentLayers) {
        if (parentLayers == null || parentLayers.isEmpty()) {
            return List.of(ModuleLayer.boot().configuration());
        }
        return parentLayers.stream().map(ModuleLayer::configuration).toList();
    }

    private static void ensureEntryPointAccessible(ModuleLayer.Controller controller, Module pluginModule, String className) {
        if (className != null) {
            controller.addOpens(pluginModule, PluginsService.toPackageName(className), serverModule);
        }
    }

    private static void addQualifiedExports(Module target) {
        serverModule.getDescriptor().exports().stream().filter(ModuleDescriptor.Exports::isQualified).filter(exports -> exports.targets().contains(target.getName())).forEach((? super T exports) -> serverModule.addExports(exports.source(), target));
    }

    private static void addQualifiedOpens(Module target) {
        serverModule.getDescriptor().opens().stream().filter(ModuleDescriptor.Opens::isQualified).filter(opens -> opens.targets().contains(target.getName())).forEach((? super T opens) -> serverModule.addExports(opens.source(), target));
    }

    static String spiModuleName(Set<URL> spiURLS) {
        ModuleFinder finder = ModuleFinder.of(PluginsService.urlsToPaths(spiURLS));
        Set<ModuleReference> mrefs = finder.findAll();
        assert (mrefs.size() == 1) : "Expected a single module, got:" + mrefs;
        return ((ModuleReference)mrefs.stream().findFirst().get()).descriptor().name();
    }

    @SuppressForbidden(reason="I need to convert URL's to Paths")
    static final Path[] urlsToPaths(Set<URL> urls) {
        return (Path[])urls.stream().map(PluginsService::uncheckedToURI).map(PathUtils::get).toArray(Path[]::new);
    }

    static final URI uncheckedToURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)new IOException(e));
        }
    }

    static final String toPackageName(String className) {
        assert (!className.endsWith("."));
        int index = className.lastIndexOf(".");
        if (index == -1) {
            throw new IllegalStateException("invalid class name:" + className);
        }
        return className.substring(0, index);
    }

    private static void privilegedSetContextClassLoader(ClassLoader loader) {
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(loader);
            return null;
        });
    }

    static ModuleLayer.Controller privilegedDefineModulesWithOneLoader(Configuration cf, List<ModuleLayer> parentLayers, ClassLoader parentLoader) {
        return AccessController.doPrivileged(() -> ModuleLayer.defineModulesWithOneLoader(cf, parentLayers, parentLoader));
    }

    static ClassLoader privilegedFindLoader(ModuleLayer layer, String name) {
        return AccessController.doPrivileged(() -> layer.findLoader(name));
    }

    record LoadedPlugin(PluginDescriptor descriptor, Plugin instance, ClassLoader loader, ModuleLayer layer) {
        LoadedPlugin {
            Objects.requireNonNull(descriptor);
            Objects.requireNonNull(instance);
            Objects.requireNonNull(loader);
            Objects.requireNonNull(layer);
        }

        LoadedPlugin(PluginDescriptor descriptor, Plugin instance) {
            this(descriptor, instance, PluginsService.class.getClassLoader(), ModuleLayer.boot());
        }
    }

    record LayerAndLoader(ModuleLayer layer, ClassLoader loader) {
        LayerAndLoader {
            Objects.requireNonNull(layer);
            Objects.requireNonNull(loader);
        }

        static LayerAndLoader ofLoader(ClassLoader loader) {
            return new LayerAndLoader(ModuleLayer.boot(), loader);
        }
    }
}

