/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.module.InvalidModuleDescriptorException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.elasticsearch.core.SuppressForbidden;

public class ModuleSupport {
    private static final String SERVICES_PREFIX = "META-INF/services/";
    private static final String MODULE_INFO = "module-info.class";

    private ModuleSupport() {
        throw new AssertionError((Object)"Utility class, should not be instantiated");
    }

    static ModuleFinder ofSyntheticPluginModule(String name, Path[] jarPaths, Set<String> requires, Set<String> uses, Predicate<String> isPackageInParentLayers) {
        try {
            return new InMemoryModuleFinder(new InMemoryModuleReference(ModuleSupport.createModuleDescriptor(name, jarPaths, requires, uses, isPackageInParentLayers), URI.create("module:/" + name)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @SuppressForbidden(reason="need access to the jar file")
    static ModuleDescriptor createModuleDescriptor(String name, Path[] jarPaths, Set<String> requires, Set<String> uses, Predicate<String> isPackageInParentLayers) throws IOException {
        ModuleDescriptor.Builder builder = ModuleDescriptor.newOpenModule(name);
        requires.stream().forEach(builder::requires);
        uses.stream().forEach(builder::uses);
        HashSet<String> pkgs = new HashSet<String>();
        HashMap<String, List> allBundledProviders = new HashMap<String, List>();
        HashSet<String> servicesUsedInBundle = new HashSet<String>();
        for (Path path : jarPaths) {
            assert (path.getFileName().toString().endsWith(".jar")) : "expected jars suffix, in path: " + path;
            try (JarFile jf = new JarFile(path.toFile(), true, 1, Runtime.version());){
                String serviceName;
                JarEntry moduleInfo = jf.getJarEntry(MODULE_INFO);
                if (moduleInfo != null) {
                    ModuleDescriptor descriptor = ModuleSupport.getDescriptorForModularJar(path);
                    pkgs.addAll(descriptor.packages());
                    servicesUsedInBundle.addAll(descriptor.uses());
                    for (ModuleDescriptor.Provides p : descriptor.provides()) {
                        serviceName = p.service();
                        List<String> providersInModule = p.providers();
                        allBundledProviders.compute(serviceName, (k, v) -> ModuleSupport.createListOrAppend(v, providersInModule));
                        servicesUsedInBundle.add(serviceName);
                    }
                    continue;
                }
                ScanResult scan = ModuleSupport.scan(jf);
                scan.classFiles().stream().map(cf -> ModuleSupport.toPackageName(cf, "/")).flatMap(Optional::stream).forEach(pkgs::add);
                for (String serviceFileName : scan.serviceFiles()) {
                    serviceName = ModuleSupport.getServiceName(serviceFileName);
                    List<String> providersInJar = ModuleSupport.getProvidersFromServiceFile(jf, serviceFileName);
                    allBundledProviders.compute(serviceName, (k, v) -> ModuleSupport.createListOrAppend(v, providersInJar));
                    servicesUsedInBundle.add(serviceName);
                }
            }
        }
        builder.packages(pkgs);
        servicesUsedInBundle.removeAll(uses);
        Set missingServices = servicesUsedInBundle.stream().filter(s -> !isPackageInParentLayers.test(ModuleSupport.toPackageName(s, ".").orElseThrow())).filter(s -> !pkgs.contains(ModuleSupport.toPackageName(s, ".").orElseThrow())).collect(Collectors.toSet());
        servicesUsedInBundle.stream().filter(s -> !missingServices.contains(s)).forEach(builder::uses);
        allBundledProviders.entrySet().stream().filter(e -> !missingServices.contains(e.getKey())).forEach(e -> builder.provides((String)e.getKey(), (List)e.getValue()));
        return builder.build();
    }

    @SuppressForbidden(reason="need access to the jar file")
    static ScanResult scan(JarFile jarFile) {
        Map map = jarFile.versionedStream().filter(e -> !e.isDirectory()).map(ZipEntry::getName).filter(e -> e.endsWith(".class") ^ e.startsWith(SERVICES_PREFIX)).collect(Collectors.partitioningBy(e -> e.startsWith(SERVICES_PREFIX), Collectors.toSet()));
        return new ScanResult(map.get(Boolean.FALSE), map.get(Boolean.TRUE));
    }

    static Optional<String> toPackageName(String name, String separator) {
        assert (!name.endsWith(separator));
        int index = name.lastIndexOf(separator);
        if (index == -1) {
            if (name.endsWith(".class") && !name.equals(MODULE_INFO)) {
                String msg = name + " found in top-level directory (unnamed package not allowed in module)";
                throw new InvalidModuleDescriptorException(msg);
            }
            return Optional.empty();
        }
        String pn = name.substring(0, index).replace(separator, ".");
        if (ModuleSupport.isPackageName(pn)) {
            return Optional.of(pn);
        }
        return Optional.empty();
    }

    static boolean isPackageName(String name) {
        return ModuleSupport.isTypeName(name);
    }

    static boolean isTypeName(String name) {
        int next;
        int off = 0;
        while ((next = name.indexOf(46, off)) != -1) {
            String id = name.substring(off, next);
            if (!ModuleSupport.isJavaIdentifier(id)) {
                return false;
            }
            off = next + 1;
        }
        String last = name.substring(off);
        return ModuleSupport.isJavaIdentifier(last);
    }

    static boolean isJavaIdentifier(String str) {
        int cp;
        if (str.isEmpty()) {
            return false;
        }
        int first = Character.codePointAt(str, 0);
        if (!Character.isJavaIdentifierStart(first)) {
            return false;
        }
        for (int i = Character.charCount(first); i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }

    static boolean hasAtLeastOneUnqualifiedExport(ModuleDescriptor md) {
        return md.exports().stream().anyMatch(Predicate.not(ModuleDescriptor.Exports::isQualified));
    }

    static boolean isJavaPlatformModule(ModuleDescriptor md) {
        return md.name().startsWith("java.") || md.name().startsWith("jdk.");
    }

    @SuppressForbidden(reason="need access to the jar file")
    private static List<String> getProvidersFromServiceFile(JarFile jf, String sf) throws IOException {
        try (BufferedReader bf = new BufferedReader(new InputStreamReader(jf.getInputStream(jf.getEntry(sf)), StandardCharsets.UTF_8));){
            List<String> list = bf.lines().filter(Predicate.not(l -> l.startsWith("#"))).filter(Predicate.not(String::isEmpty)).toList();
            return list;
        }
    }

    private static List<String> createListOrAppend(List<String> currentList, List<String> newList) {
        if (currentList == null) {
            return List.copyOf(newList);
        }
        return Stream.concat(currentList.stream(), newList.stream()).toList();
    }

    private static String getServiceName(String sf) {
        return sf.substring(SERVICES_PREFIX.length());
    }

    private static ModuleDescriptor getDescriptorForModularJar(Path path) {
        return ((ModuleReference)ModuleFinder.of(path).findAll().stream().findFirst().orElseThrow(() -> new IllegalStateException("found a module descriptor but failed to load a module from " + path))).descriptor();
    }

    static class InMemoryModuleFinder
    implements ModuleFinder {
        private final ModuleReference mref;
        private final String mn;

        private InMemoryModuleFinder(ModuleReference mref) {
            this.mref = mref;
            this.mn = mref.descriptor().name();
        }

        @Override
        public Optional<ModuleReference> find(String name) {
            Objects.requireNonNull(name);
            return Optional.ofNullable(this.mn.equals(name) ? this.mref : null);
        }

        @Override
        public Set<ModuleReference> findAll() {
            return Set.of(this.mref);
        }
    }

    static class InMemoryModuleReference
    extends ModuleReference {
        InMemoryModuleReference(ModuleDescriptor descriptor, URI location) {
            super(descriptor, location);
        }

        @Override
        public ModuleReader open() {
            throw new UnsupportedOperationException();
        }
    }

    record ScanResult(Set<String> classFiles, Set<String> serviceFiles) {
    }
}

