/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Assertions;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private static final Logger logger = LogManager.getLogger(IndexShardOperationPermits.class);
    private final ShardId shardId;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<DelayedOperation> delayedOperations = new ArrayList<DelayedOperation>();
    private volatile boolean closed;
    private int queuedBlockOperations;
    private final Map<AtomicBoolean, Tuple<String, StackTraceElement[]>> issuedPermits;

    IndexShardOperationPermits(ShardId shardId, ThreadPool threadPool) {
        this.shardId = shardId;
        this.threadPool = threadPool;
        this.issuedPermits = Assertions.ENABLED ? new ConcurrentHashMap<AtomicBoolean, Tuple<String, StackTraceElement[]>>() : null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public void blockOperations(ActionListener<Releasable> onAcquired, long timeout, TimeUnit timeUnit, String executor) {
        this.delayOperations();
        this.waitUntilBlocked(ActionListener.assertOnce(onAcquired), timeout, timeUnit, executor);
    }

    private void waitUntilBlocked(final ActionListener<Releasable> onAcquired, final long timeout, final TimeUnit timeUnit, String executor) {
        this.threadPool.executor(executor).execute(new AbstractRunnable(){
            final Releasable released = Releasables.releaseOnce(() -> IndexShardOperationPermits.this.releaseDelayedOperations());

            @Override
            public void onFailure(Exception e) {
                try {
                    this.released.close();
                }
                finally {
                    onAcquired.onFailure(e);
                }
            }

            @Override
            protected void doRun() {
                Releasable releasable;
                try {
                    releasable = IndexShardOperationPermits.this.acquireAll(timeout, timeUnit);
                }
                catch (Exception e) {
                    this.onFailure(e);
                    return;
                }
                Releasable combined = Releasables.wrap((Releasable[])new Releasable[]{releasable, this.released});
                try {
                    onAcquired.onResponse(combined);
                }
                catch (Exception e) {
                    logger.error("onAcquired#onResponse should not throw", (Throwable)e);
                    assert (false) : e;
                    combined.close();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0 || this.delayedOperations.isEmpty());
            ++this.queuedBlockOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Releasable acquireAll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.queuedBlockOperations > 0);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            Releasable release = Releasables.releaseOnce(() -> {
                assert (this.semaphore.availablePermits() == 0);
                this.semaphore.release(Integer.MAX_VALUE);
            });
            return release;
        }
        throw new ElasticsearchTimeoutException("timeout while blocking operations after [" + new TimeValue(timeout, timeUnit) + "]", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        List queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0);
            --this.queuedBlockOperations;
            if (this.queuedBlockOperations == 0) {
                queuedActions = new ArrayList<DelayedOperation>(this.delayedOperations);
                this.delayedOperations.clear();
            } else {
                queuedActions = Collections.emptyList();
            }
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (DelayedOperation queuedAction : queuedActions) {
                    this.acquire(queuedAction.listener, null, false, queuedAction.debugInfo, queuedAction.stackTrace);
                }
            });
        }
    }

    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution, Object debugInfo) {
        StackTraceElement[] stackTrace = Assertions.ENABLED ? Thread.currentThread().getStackTrace() : null;
        this.acquire(ActionListener.assertOnce(onAcquired), executorOnDelay, forceExecution, debugInfo, stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, final boolean forceExecution, Object debugInfo, StackTraceElement[] stackTrace) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.queuedBlockOperations > 0) {
                    Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(false);
                    ActionListener<Releasable> wrappedListener = executorOnDelay != null ? new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired).delegateFailure((l, r) -> this.threadPool.executor(executorOnDelay).execute(new ActionRunnable<Releasable>(l){

                        @Override
                        public boolean isForceExecution() {
                            return forceExecution;
                        }

                        @Override
                        protected void doRun() {
                            this.listener.onResponse(r);
                        }

                        @Override
                        public void onRejection(Exception e) {
                            IOUtils.closeWhileHandlingException((Closeable)r);
                            super.onRejection(e);
                        }
                    })) : new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired);
                    this.delayedOperations.add(new DelayedOperation(wrappedListener, debugInfo, stackTrace));
                    return;
                }
                releasable = this.acquire(debugInfo, stackTrace);
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire(Object debugInfo, StackTraceElement[] stackTrace) throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            Releasable releasable = () -> {
                if (closed.compareAndSet(false, true)) {
                    if (Assertions.ENABLED) {
                        Tuple<String, StackTraceElement[]> existing = this.issuedPermits.remove(closed);
                        assert (existing != null);
                    }
                    this.semaphore.release(1);
                }
            };
            if (Assertions.ENABLED) {
                this.issuedPermits.put(closed, (Tuple<String, StackTraceElement[]>)new Tuple((Object)debugInfo.toString(), (Object)stackTrace));
            }
            return releasable;
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return -1;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    synchronized boolean isBlocked() {
        return this.queuedBlockOperations > 0;
    }

    List<String> getActiveOperations() {
        return this.issuedPermits.values().stream().map(t -> (String)t.v1() + "\n" + ExceptionsHelper.formatStackTrace((StackTraceElement[])t.v2())).toList();
    }

    private static class DelayedOperation {
        private final ActionListener<Releasable> listener;
        private final String debugInfo;
        private final StackTraceElement[] stackTrace;

        private DelayedOperation(ActionListener<Releasable> listener, Object debugInfo, StackTraceElement[] stackTrace) {
            this.listener = listener;
            if (Assertions.ENABLED) {
                this.debugInfo = "[delayed] " + debugInfo;
                this.stackTrace = stackTrace;
            } else {
                this.debugInfo = null;
                this.stackTrace = null;
            }
        }
    }
}

