/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BoolQueryBuilder
extends AbstractQueryBuilder<BoolQueryBuilder> {
    public static final String NAME = "bool";
    public static final boolean ADJUST_PURE_NEGATIVE_DEFAULT = true;
    private static final ParseField MUST_NOT = new ParseField("must_not", new String[0]).withDeprecation(new String[]{"mustNot"});
    private static final ParseField FILTER = new ParseField("filter", new String[0]);
    private static final ParseField SHOULD = new ParseField("should", new String[0]);
    private static final ParseField MUST = new ParseField("must", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField ADJUST_PURE_NEGATIVE = new ParseField("adjust_pure_negative", new String[0]);
    private final List<QueryBuilder> mustClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> mustNotClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> filterClauses = new ArrayList<QueryBuilder>();
    private final List<QueryBuilder> shouldClauses = new ArrayList<QueryBuilder>();
    private boolean adjustPureNegative = true;
    private String minimumShouldMatch;
    private static final ObjectParser<BoolQueryBuilder, Void> PARSER = new ObjectParser("bool", BoolQueryBuilder::new);

    public BoolQueryBuilder() {
    }

    public BoolQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.mustClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.mustNotClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.shouldClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.filterClauses.addAll(BoolQueryBuilder.readQueries(in));
        this.adjustPureNegative = in.readBoolean();
        this.minimumShouldMatch = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        BoolQueryBuilder.writeQueries(out, this.mustClauses);
        BoolQueryBuilder.writeQueries(out, this.mustNotClauses);
        BoolQueryBuilder.writeQueries(out, this.shouldClauses);
        BoolQueryBuilder.writeQueries(out, this.filterClauses);
        out.writeBoolean(this.adjustPureNegative);
        out.writeOptionalString(this.minimumShouldMatch);
    }

    public BoolQueryBuilder must(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> must() {
        return this.mustClauses;
    }

    public BoolQueryBuilder filter(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.filterClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> filter() {
        return this.filterClauses;
    }

    public BoolQueryBuilder mustNot(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.mustNotClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> mustNot() {
        return this.mustNotClauses;
    }

    public BoolQueryBuilder should(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner bool query clause cannot be null");
        }
        this.shouldClauses.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> should() {
        return this.shouldClauses;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public BoolQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public BoolQueryBuilder minimumShouldMatch(int minimumShouldMatch) {
        this.minimumShouldMatch = Integer.toString(minimumShouldMatch);
        return this;
    }

    public boolean hasClauses() {
        return !(this.mustClauses.isEmpty() && this.shouldClauses.isEmpty() && this.mustNotClauses.isEmpty() && this.filterClauses.isEmpty());
    }

    public BoolQueryBuilder adjustPureNegative(boolean adjustPureNegative) {
        this.adjustPureNegative = adjustPureNegative;
        return this;
    }

    public boolean adjustPureNegative() {
        return this.adjustPureNegative;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        BoolQueryBuilder.doXArrayContent(MUST, this.mustClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(FILTER, this.filterClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(MUST_NOT, this.mustNotClauses, builder, params);
        BoolQueryBuilder.doXArrayContent(SHOULD, this.shouldClauses, builder, params);
        if (builder.getRestApiVersion() == RestApiVersion.V_7) {
            builder.field(ADJUST_PURE_NEGATIVE.getPreferredName(), this.adjustPureNegative);
        } else if (!this.adjustPureNegative) {
            builder.field(ADJUST_PURE_NEGATIVE.getPreferredName(), this.adjustPureNegative);
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static void doXArrayContent(ParseField field, List<QueryBuilder> clauses, XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (clauses.isEmpty()) {
            return;
        }
        builder.startArray(field.getPreferredName());
        for (QueryBuilder clause : clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
    }

    public static BoolQueryBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        return (BoolQueryBuilder)PARSER.parse(parser, null);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustClauses, BooleanClause.Occur.MUST);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.mustNotClauses, BooleanClause.Occur.MUST_NOT);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.shouldClauses, BooleanClause.Occur.SHOULD);
        BoolQueryBuilder.addBooleanClauses(context, booleanQueryBuilder, this.filterClauses, BooleanClause.Occur.FILTER);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        if (booleanQuery.clauses().isEmpty()) {
            return new MatchAllDocsQuery();
        }
        Query query = Queries.applyMinimumShouldMatch(booleanQuery, this.minimumShouldMatch);
        return this.adjustPureNegative ? Queries.fixNegativeQueryIfNeeded(query) : query;
    }

    private static void addBooleanClauses(SearchExecutionContext context, BooleanQuery.Builder booleanQueryBuilder, List<QueryBuilder> clauses, BooleanClause.Occur occurs) throws IOException {
        for (QueryBuilder query : clauses) {
            Query luceneQuery = query.toQuery(context);
            booleanQueryBuilder.add(new BooleanClause(luceneQuery, occurs));
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.adjustPureNegative, this.minimumShouldMatch, this.mustClauses, this.shouldClauses, this.mustNotClauses, this.filterClauses);
    }

    @Override
    protected boolean doEquals(BoolQueryBuilder other) {
        return Objects.equals(this.adjustPureNegative, other.adjustPureNegative) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.mustClauses, other.mustClauses) && Objects.equals(this.shouldClauses, other.shouldClauses) && Objects.equals(this.mustNotClauses, other.mustNotClauses) && Objects.equals(this.filterClauses, other.filterClauses);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        BoolQueryBuilder newBuilder = new BoolQueryBuilder();
        boolean changed = false;
        int clauses = this.mustClauses.size() + this.mustNotClauses.size() + this.filterClauses.size() + this.shouldClauses.size();
        if (clauses == 0) {
            return ((MatchAllQueryBuilder)new MatchAllQueryBuilder().boost(this.boost())).queryName(this.queryName());
        }
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustClauses, newBuilder::must);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.mustNotClauses, newBuilder::mustNot);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.filterClauses, newBuilder::filter);
        changed |= BoolQueryBuilder.rewriteClauses(queryRewriteContext, this.shouldClauses, newBuilder::should);
        if (this.mustClauses.size() == 0 && this.filterClauses.size() == 0 && this.shouldClauses.size() > 0 && newBuilder.shouldClauses.stream().allMatch(b -> b instanceof MatchNoneQueryBuilder)) {
            return new MatchNoneQueryBuilder();
        }
        if (newBuilder.mustClauses.stream().anyMatch(b -> b instanceof MatchNoneQueryBuilder) || newBuilder.filterClauses.stream().anyMatch(b -> b instanceof MatchNoneQueryBuilder) || newBuilder.mustNotClauses.stream().anyMatch(b -> b instanceof MatchAllQueryBuilder)) {
            return new MatchNoneQueryBuilder();
        }
        if (changed) {
            newBuilder.adjustPureNegative = this.adjustPureNegative;
            newBuilder.minimumShouldMatch = this.minimumShouldMatch;
            newBuilder.boost(this.boost());
            newBuilder.queryName(this.queryName());
            return newBuilder;
        }
        return this;
    }

    @Override
    protected void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        ArrayList<QueryBuilder> clauses = new ArrayList<QueryBuilder>(this.filter());
        clauses.addAll(this.must());
        clauses.addAll(this.should());
        for (QueryBuilder clause : clauses) {
            InnerHitContextBuilder.extractInnerHits(clause, innerHits);
        }
    }

    private static boolean rewriteClauses(QueryRewriteContext queryRewriteContext, List<QueryBuilder> builders, Consumer<QueryBuilder> consumer) throws IOException {
        boolean changed = false;
        for (QueryBuilder builder : builders) {
            QueryBuilder result = builder.rewrite(queryRewriteContext);
            if (result != builder) {
                changed = true;
            }
            consumer.accept(result);
        }
        return changed;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.ZERO;
    }

    static {
        PARSER.declareObjectArrayOrNull((builder, clauses) -> clauses.forEach(builder::must), (p, c) -> BoolQueryBuilder.parseInnerQueryBuilder(p), MUST);
        PARSER.declareObjectArrayOrNull((builder, clauses) -> clauses.forEach(builder::should), (p, c) -> BoolQueryBuilder.parseInnerQueryBuilder(p), SHOULD);
        PARSER.declareObjectArrayOrNull((builder, clauses) -> clauses.forEach(builder::mustNot), (p, c) -> BoolQueryBuilder.parseInnerQueryBuilder(p), MUST_NOT);
        PARSER.declareObjectArrayOrNull((builder, clauses) -> clauses.forEach(builder::filter), (p, c) -> BoolQueryBuilder.parseInnerQueryBuilder(p), FILTER);
        PARSER.declareBoolean(BoolQueryBuilder::adjustPureNegative, ADJUST_PURE_NEGATIVE);
        PARSER.declareField(BoolQueryBuilder::minimumShouldMatch, (p, c) -> p.textOrNull(), MINIMUM_SHOULD_MATCH, ObjectParser.ValueType.VALUE);
        PARSER.declareString(AbstractQueryBuilder::queryName, NAME_FIELD);
        PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
    }
}

