/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.lucene95.Lucene95HnswVectorsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.VectorIndexFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DenseVectorFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "dense_vector";
    public static short MAX_DIMS_COUNT = (short)2048;
    public static final int MAGNITUDE_BYTES = 4;
    static final Map<String, ElementType> namesToElementType = Map.of(ElementType.BYTE.toString(), ElementType.BYTE, ElementType.FLOAT.toString(), ElementType.FLOAT);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), DenseVectorFieldMapper.notInMultiFields("dense_vector"));
    private final ElementType elementType;
    private final int dims;
    private final boolean indexed;
    private final VectorSimilarity similarity;
    private final IndexOptions indexOptions;
    private final Version indexCreatedVersion;

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, ElementType elementType, int dims, boolean indexed, VectorSimilarity similarity, IndexOptions indexOptions, Version indexCreatedVersion, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.elementType = elementType;
        this.dims = dims;
        this.indexed = indexed;
        this.similarity = similarity;
        this.indexOptions = indexOptions;
        this.indexCreatedVersion = indexCreatedVersion;
    }

    @Override
    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey(this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        Field field = this.fieldType().indexed ? this.parseKnnVector(context) : this.parseBinaryDocValuesVector(context);
        context.doc().addWithKey(this.fieldType().name(), (IndexableField)field);
    }

    private Field parseKnnVector(DocumentParserContext context) throws IOException {
        return this.elementType.parseKnnVector(context, this);
    }

    private Field parseBinaryDocValuesVector(DocumentParserContext context) throws IOException {
        byte[] bytes = this.indexCreatedVersion.onOrAfter(Version.V_7_5_0) ? new byte[this.dims * this.elementType.elementBytes + 4] : new byte[this.dims * this.elementType.elementBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        double dotProduct = this.elementType.parseKnnVectorToByteBuffer(context, this, byteBuffer);
        if (this.indexCreatedVersion.onOrAfter(Version.V_7_5_0)) {
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        return new BinaryDocValuesField(this.fieldType().name(), new BytesRef(bytes));
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.name() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.dims + "]");
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.indexCreatedVersion).init(this);
    }

    @Override
    public void doValidate(MappingLookup mappers) {
        if (this.indexed && mappers.nestedLookup().getNestedParent(this.name()) != null) {
            throw new IllegalArgumentException("[dense_vector] fields cannot be indexed if they're within [nested] mappings");
        }
    }

    private static IndexOptions parseIndexOptions(String fieldName, Object propNode) {
        Map indexOptionsMap = (Map)propNode;
        Object typeNode = indexOptionsMap.remove("type");
        if (typeNode == null) {
            throw new MapperParsingException("[index_options] requires field [type] to be configured");
        }
        String type = XContentMapValues.nodeStringValue(typeNode);
        if (type.equals("hnsw")) {
            return HnswIndexOptions.parseIndexOptions(fieldName, indexOptionsMap);
        }
        throw new MapperParsingException("Unknown vector index options type [" + type + "] for field [" + fieldName + "]");
    }

    public KnnVectorsFormat getKnnVectorsFormatForField() {
        if (this.indexOptions == null) {
            return null;
        }
        HnswIndexOptions hnswIndexOptions = (HnswIndexOptions)this.indexOptions;
        return new Lucene95HnswVectorsFormat(hnswIndexOptions.m, hnswIndexOptions.efConstruction);
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support synthetic source because it declares copy_to");
        }
        if (this.indexed) {
            return new IndexedSyntheticFieldLoader();
        }
        return new DocValuesSyntheticFieldLoader();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ElementType {
        BYTE(1){

            public String toString() {
                return "byte";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.put((byte)value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.get());
            }

            @Override
            KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                return new KnnByteVectorField(name, vector, function);
            }

            @Override
            KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
                throw new IllegalArgumentException("cannot create a float vector field from byte");
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
                StringBuilder errorBuilder = null;
                for (int index = 0; index < vector.length; ++index) {
                    float value = vector[index];
                    if (value % 1.0f != 0.0f) {
                        errorBuilder = new StringBuilder("element_type [" + this + "] vectors only support non-decimal values but found decimal value [" + value + "] at dim [" + index + "];");
                        break;
                    }
                    if (!(value < -128.0f) && !(value > 127.0f)) continue;
                    errorBuilder = new StringBuilder("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(this.appendErrorElements(errorBuilder, vector).toString());
                }
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.COSINE + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public Field parseKnnVector(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                int index = 0;
                byte[] vector = new byte[fieldMapper.dims];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    int value;
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    if (context.parser().numberType() != XContentParser.NumberType.INT) {
                        float floatValue = context.parser().floatValue(true);
                        if (floatValue % 1.0f != 0.0f) {
                            throw new IllegalArgumentException("element_type [" + this + "] vectors only support non-decimal values but found decimal value [" + floatValue + "] at dim [" + index + "];");
                        }
                        value = (int)floatValue;
                    } else {
                        value = context.parser().intValue(true);
                    }
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    vector[index++] = (byte)value;
                    squaredMagnitude += (float)(value * value);
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorMagnitude(fieldMapper.similarity, this.errorByteElementsAppender(vector), squaredMagnitude);
                return this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.similarity.function);
            }

            @Override
            double parseKnnVectorToByteBuffer(DocumentParserContext context, DenseVectorFieldMapper fieldMapper, ByteBuffer byteBuffer) throws IOException {
                double dotProduct = 0.0;
                int index = 0;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    int value = context.parser().intValue(true);
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + this + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    byteBuffer.put((byte)value);
                    dotProduct += (double)(value * value);
                    ++index;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                return dotProduct;
            }
        }
        ,
        FLOAT(4){

            public String toString() {
                return "float";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.putFloat(value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.getFloat());
            }

            @Override
            KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
                return new KnnFloatVectorField(name, vector, function);
            }

            @Override
            KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                throw new IllegalArgumentException("cannot create a byte vector field from float");
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (similarity == VectorSimilarity.DOT_PRODUCT && Math.abs(squaredMagnitude - 1.0f) > 1.0E-4f) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.DOT_PRODUCT + "] similarity can only be used with unit-length vectors.");
                } else if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + VectorSimilarity.COSINE + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public Field parseKnnVector(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                int index = 0;
                float[] vector = new float[fieldMapper.dims];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    float value = context.parser().floatValue(true);
                    vector[index++] = value;
                    squaredMagnitude += value * value;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorBounds(vector);
                this.checkVectorMagnitude(fieldMapper.similarity, this.errorFloatElementsAppender(vector), squaredMagnitude);
                return this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.similarity.function);
            }

            @Override
            double parseKnnVectorToByteBuffer(DocumentParserContext context, DenseVectorFieldMapper fieldMapper, ByteBuffer byteBuffer) throws IOException {
                double dotProduct = 0.0;
                int index = 0;
                float[] vector = new float[fieldMapper.dims];
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    float value;
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    vector[index] = value = context.parser().floatValue(true);
                    byteBuffer.putFloat(value);
                    dotProduct += (double)(value * value);
                    ++index;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorBounds(vector);
                return dotProduct;
            }
        };

        final int elementBytes;

        private ElementType(int elementBytes) {
            this.elementBytes = elementBytes;
        }

        public abstract void writeValue(ByteBuffer var1, float var2);

        public abstract void readAndWriteValue(ByteBuffer var1, XContentBuilder var2) throws IOException;

        abstract KnnFloatVectorField createKnnVectorField(String var1, float[] var2, VectorSimilarityFunction var3);

        abstract KnnByteVectorField createKnnVectorField(String var1, byte[] var2, VectorSimilarityFunction var3);

        abstract IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType var1, FieldDataContext var2);

        abstract Field parseKnnVector(DocumentParserContext var1, DenseVectorFieldMapper var2) throws IOException;

        abstract double parseKnnVectorToByteBuffer(DocumentParserContext var1, DenseVectorFieldMapper var2, ByteBuffer var3) throws IOException;

        public abstract void checkVectorBounds(float[] var1);

        abstract void checkVectorMagnitude(VectorSimilarity var1, Function<StringBuilder, StringBuilder> var2, float var3);

        void checkNanAndInfinite(float[] vector) {
            StringBuilder errorBuilder = null;
            for (int index = 0; index < vector.length; ++index) {
                float value = vector[index];
                if (Float.isNaN(value)) {
                    errorBuilder = new StringBuilder("element_type [" + this + "] vectors do not support NaN values but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (!Float.isInfinite(value)) continue;
                errorBuilder = new StringBuilder("element_type [" + this + "] vectors do not support infinite values but found [" + value + "] at dim [" + index + "];");
                break;
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(this.appendErrorElements(errorBuilder, vector).toString());
            }
        }

        StringBuilder appendErrorElements(StringBuilder errorBuilder, float[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        StringBuilder appendErrorElements(StringBuilder errorBuilder, byte[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        Function<StringBuilder, StringBuilder> errorFloatElementsAppender(float[] vector) {
            return sb -> this.appendErrorElements((StringBuilder)sb, vector);
        }

        Function<StringBuilder, StringBuilder> errorByteElementsAppender(byte[] vector) {
            return sb -> this.appendErrorElements((StringBuilder)sb, vector);
        }
    }

    static enum VectorSimilarity {
        L2_NORM(VectorSimilarityFunction.EUCLIDEAN),
        COSINE(VectorSimilarityFunction.COSINE),
        DOT_PRODUCT(VectorSimilarityFunction.DOT_PRODUCT);

        public final VectorSimilarityFunction function;

        private VectorSimilarity(VectorSimilarityFunction function) {
            this.function = function;
        }

        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static abstract class IndexOptions
    implements ToXContent {
        final String type;

        IndexOptions(String type) {
            this.type = type;
        }
    }

    public static final class DenseVectorFieldType
    extends SimpleMappedFieldType {
        private final ElementType elementType;
        private final int dims;
        private final boolean indexed;
        private final VectorSimilarity similarity;
        private final Version indexVersionCreated;

        public DenseVectorFieldType(String name, Version indexVersionCreated, ElementType elementType, int dims, boolean indexed, VectorSimilarity similarity, Map<String, String> meta) {
            super(name, indexed, false, !indexed, TextSearchInfo.NONE, meta);
            this.elementType = elementType;
            this.dims = dims;
            this.indexed = indexed;
            this.similarity = similarity;
            this.indexVersionCreated = indexVersionCreated;
        }

        @Override
        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support docvalue_fields or aggregations");
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return this.elementType.fielddataBuilder(this, fieldDataContext);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        public Query createKnnQuery(byte[] queryVector, int numCands, Query filter) {
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (queryVector.length != this.dims) {
                throw new IllegalArgumentException("the query vector has a different dimension [" + queryVector.length + "] than the index vectors [" + this.dims + "]");
            }
            if (this.elementType != ElementType.BYTE) {
                throw new IllegalArgumentException("only [" + ElementType.BYTE + "] elements are supported when querying field [" + this.name() + "]");
            }
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = 0.0f;
                for (byte b : queryVector) {
                    squaredMagnitude += (float)(b * b);
                }
                this.elementType.checkVectorMagnitude(this.similarity, this.elementType.errorByteElementsAppender(queryVector), squaredMagnitude);
            }
            return new KnnByteVectorQuery(this.name(), queryVector, numCands, filter);
        }

        public Query createKnnQuery(float[] queryVector, int numCands, Query filter) {
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            if (queryVector.length != this.dims) {
                throw new IllegalArgumentException("the query vector has a different dimension [" + queryVector.length + "] than the index vectors [" + this.dims + "]");
            }
            this.elementType.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = 0.0f;
                for (float e : queryVector) {
                    squaredMagnitude += e * e;
                }
                this.elementType.checkVectorMagnitude(this.similarity, this.elementType.errorFloatElementsAppender(queryVector), squaredMagnitude);
            }
            return switch (this.elementType) {
                default -> throw new IncompatibleClassChangeError();
                case ElementType.BYTE -> {
                    byte[] bytes = new byte[queryVector.length];
                    for (int i = 0; i < queryVector.length; ++i) {
                        bytes[i] = (byte)queryVector[i];
                    }
                    yield new KnnByteVectorQuery(this.name(), bytes, numCands, filter);
                }
                case ElementType.FLOAT -> new KnnFloatVectorQuery(this.name(), queryVector, numCands, filter);
            };
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<ElementType> elementType = new FieldMapper.Parameter<ElementType>("element_type", false, () -> ElementType.FLOAT, (n, c, o) -> {
            ElementType elementType = namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + o + "]; available types are " + namesToElementType.keySet());
            }
            return elementType;
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).elementType, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter<Integer>("dims", false, () -> null, (n, c, o) -> XContentMapValues.nodeIntegerValue(o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).dims, XContentBuilder::field, Objects::toString).addValidator(dims -> {
            if (dims == null) {
                throw new MapperParsingException("Missing required parameter [dims] for field [" + this.name + "]");
            }
            if (dims > MAX_DIMS_COUNT || dims < 1) {
                throw new MapperParsingException("The number of dimensions for field [" + this.name + "] should be in the range [1, " + MAX_DIMS_COUNT + "] but was [" + dims + "]");
            }
        });
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexed, false);
        private final FieldMapper.Parameter<VectorSimilarity> similarity = FieldMapper.Parameter.enumParam("similarity", false, m -> DenseVectorFieldMapper.toType((FieldMapper)m).similarity, null, VectorSimilarity.class);
        private final FieldMapper.Parameter<IndexOptions> indexOptions = new FieldMapper.Parameter<IndexOptions>("index_options", false, () -> null, (n, c, o) -> o == null ? null : DenseVectorFieldMapper.parseIndexOptions(n, o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexOptions, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final Version indexVersionCreated;

        public Builder(String name, Version indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            this.indexed.requiresParameter(this.similarity);
            this.similarity.setSerializerCheck((id, ic, v) -> v != null);
            this.similarity.requiresParameter(this.indexed);
            this.indexOptions.requiresParameter(this.indexed);
            this.indexOptions.setSerializerCheck((id, ic, v) -> v != null);
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.indexed, this.similarity, this.indexOptions, this.meta};
        }

        @Override
        public DenseVectorFieldMapper build(MapperBuilderContext context) {
            return new DenseVectorFieldMapper(this.name, new DenseVectorFieldType(context.buildFullName(this.name), this.indexVersionCreated, this.elementType.getValue(), this.dims.getValue(), this.indexed.getValue(), this.similarity.getValue(), this.meta.getValue()), this.elementType.getValue(), this.dims.getValue(), this.indexed.getValue(), this.similarity.getValue(), this.indexOptions.getValue(), this.indexVersionCreated, this.multiFieldsBuilder.build(this, context), this.copyTo.build());
        }
    }

    private static class HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;

        static IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
            Object mNode = indexOptionsMap.remove("m");
            Object efConstructionNode = indexOptionsMap.remove("ef_construction");
            if (mNode == null) {
                throw new MapperParsingException("[index_options] of type [hnsw] requires field [m] to be configured");
            }
            if (efConstructionNode == null) {
                throw new MapperParsingException("[index_options] of type [hnsw] requires field [ef_construction] to be configured");
            }
            int m = XContentMapValues.nodeIntegerValue(mNode);
            int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
            MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
            return new HnswIndexOptions(m, efConstruction);
        }

        private HnswIndexOptions(int m, int efConstruction) {
            super("hnsw");
            this.m = m;
            this.efConstruction = efConstruction;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HnswIndexOptions that = (HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.m, this.efConstruction);
        }

        public String toString() {
            return "{type=" + this.type + ", m=" + this.m + ", ef_construction=" + this.efConstruction + " }";
        }
    }

    private class IndexedSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private FloatVectorValues values;
        private ByteVectorValues byteVectorValues;
        private boolean hasValue;

        private IndexedSyntheticFieldLoader() {
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getFloatVectorValues(DenseVectorFieldMapper.this.name());
            if (this.values != null) {
                return docId -> {
                    this.hasValue = docId == this.values.advance(docId);
                    return this.hasValue;
                };
            }
            this.byteVectorValues = leafReader.getByteVectorValues(DenseVectorFieldMapper.this.name());
            if (this.byteVectorValues != null) {
                return docId -> {
                    this.hasValue = docId == this.byteVectorValues.advance(docId);
                    return this.hasValue;
                };
            }
            return null;
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(DenseVectorFieldMapper.this.simpleName());
            if (this.values != null) {
                for (float v : this.values.vectorValue()) {
                    b.value(v);
                }
            } else if (this.byteVectorValues != null) {
                byte[] vectorValue;
                for (byte value : vectorValue = this.byteVectorValues.vectorValue()) {
                    b.value(value);
                }
            }
            b.endArray();
        }
    }

    private class DocValuesSyntheticFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;

        private DocValuesSyntheticFieldLoader() {
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return Stream.of(new Map.Entry[0]);
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(DenseVectorFieldMapper.this.name());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                this.hasValue = docId == this.values.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(DenseVectorFieldMapper.this.simpleName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length);
            for (int dim = 0; dim < DenseVectorFieldMapper.this.dims; ++dim) {
                DenseVectorFieldMapper.this.elementType.readAndWriteValue(byteBuffer, b);
            }
            b.endArray();
        }
    }
}

