/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class TypeParsers {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeParsers.class);

    public static Map<String, String> parseMeta(String name, Object metaObject) {
        if (!(metaObject instanceof Map)) {
            throw new MapperParsingException("[meta] must be an object, got " + metaObject.getClass().getSimpleName() + "[" + metaObject + "] for field [" + name + "]");
        }
        Map meta = (Map)metaObject;
        if (meta.size() > 5) {
            throw new MapperParsingException("[meta] can't have more than 5 entries, but got " + meta.size() + " on field [" + name + "]");
        }
        for (String key : meta.keySet()) {
            if (key.codePointCount(0, key.length()) <= 20) continue;
            throw new MapperParsingException("[meta] keys can't be longer than 20 chars, but got [" + key + "] for field [" + name + "]");
        }
        for (Object value : meta.values()) {
            if (value instanceof String) {
                String sValue = (String)value;
                if (sValue.codePointCount(0, sValue.length()) <= 50) continue;
                throw new MapperParsingException("[meta] values can't be longer than 50 chars, but got [" + value + "] for field [" + name + "]");
            }
            if (value == null) {
                throw new MapperParsingException("[meta] values can't be null (field [" + name + "])");
            }
            throw new MapperParsingException("[meta] values can only be strings, but got " + value.getClass().getSimpleName() + "[" + value + "] for field [" + name + "]");
        }
        TreeMap<String, String> sortedMeta = new TreeMap<String, String>();
        for (Map.Entry entry : meta.entrySet()) {
            sortedMeta.put((String)entry.getKey(), (String)entry.getValue());
        }
        return Collections.unmodifiableMap(sortedMeta);
    }

    public static boolean parseMultiField(Consumer<FieldMapper.Builder> multiFieldsBuilder, String name, MappingParserContext parserContext, String propName, Object propNode) {
        if (propName.equals("fields")) {
            Map multiFieldsPropNodes;
            if (parserContext.isWithinMultiField()) {
                if (parserContext.indexVersionCreated().before(Version.V_8_0_0)) {
                    deprecationLogger.warn(DeprecationCategory.INDICES, "multifield_within_multifield", "At least one multi-field, [" + name + "], was encountered that itself contains a multi-field. Defining multi-fields within a multi-field is deprecated and is not supported for indices created in 8.0 and later. To migrate the mappings, all instances of [fields] that occur within a [fields] block should be removed from the mappings, either by flattening the chained [fields] blocks into a single level, or switching to [copy_to] if appropriate.", new Object[0]);
                } else {
                    throw new IllegalArgumentException("Encountered a multi-field [" + name + "] which itself contains a multi-field. Defining chained multi-fields is not supported.");
                }
            }
            parserContext = parserContext.createMultiFieldContext();
            if (propNode instanceof List && ((List)propNode).isEmpty()) {
                multiFieldsPropNodes = Collections.emptyMap();
            } else if (propNode instanceof Map) {
                multiFieldsPropNodes = (Map)propNode;
            } else {
                throw new MapperParsingException("expected map for property [fields] on field [" + propNode + "] or [" + propName + "] but got a " + propNode.getClass());
            }
            for (Map.Entry multiFieldEntry : multiFieldsPropNodes.entrySet()) {
                String multiFieldName = (String)multiFieldEntry.getKey();
                if (multiFieldName.contains(".")) {
                    throw new MapperParsingException("Field name [" + multiFieldName + "] which is a multi field of [" + name + "] cannot contain '.'");
                }
                if (!(multiFieldEntry.getValue() instanceof Map)) {
                    throw new MapperParsingException("illegal field [" + multiFieldName + "], only fields can be specified inside fields");
                }
                Map multiFieldNodes = (Map)multiFieldEntry.getValue();
                Object typeNode = multiFieldNodes.get("type");
                if (typeNode == null) {
                    throw new MapperParsingException("no type specified for property [" + multiFieldName + "]");
                }
                String type = typeNode.toString();
                Mapper.TypeParser typeParser = parserContext.typeParser(type);
                if (typeParser == null) {
                    throw new MapperParsingException("no handler for type [" + type + "] declared on field [" + multiFieldName + "]");
                }
                if (!(typeParser instanceof FieldMapper.TypeParser)) {
                    throw new MapperParsingException("Type [" + type + "] cannot be used in multi field");
                }
                FieldMapper.TypeParser fieldTypeParser = (FieldMapper.TypeParser)typeParser;
                multiFieldsBuilder.accept((FieldMapper.Builder)fieldTypeParser.parse(multiFieldName, multiFieldNodes, parserContext));
                multiFieldNodes.remove("type");
                MappingParser.checkNoRemainingFields(propName, multiFieldNodes);
            }
            return true;
        }
        return false;
    }

    public static DateFormatter parseDateTimeFormatter(Object node) {
        if (node instanceof String) {
            return DateFormatter.forPattern((String)node);
        }
        throw new IllegalArgumentException("Invalid format: [" + node.toString() + "]: expected string value");
    }

    public static List<String> parseCopyFields(Object propNode) {
        ArrayList<String> copyFields = new ArrayList<String>();
        if (XContentMapValues.isArray(propNode)) {
            for (Object node : (List)propNode) {
                copyFields.add(XContentMapValues.nodeStringValue(node, null));
            }
        } else {
            copyFields.add(XContentMapValues.nodeStringValue(propNode, null));
        }
        return copyFields;
    }

    public static SimilarityProvider resolveSimilarity(MappingParserContext parserContext, String name, Object value) {
        if (value == null) {
            return null;
        }
        SimilarityProvider similarityProvider = parserContext.getSimilarity(value.toString());
        if (similarityProvider == null) {
            throw new MapperParsingException("Unknown Similarity type [" + value + "] for field [" + name + "]");
        }
        return similarityProvider;
    }
}

