/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.StoredValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;

public final class IgnoredFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_ignored";
    public static final String CONTENT_TYPE = "_ignored";
    public static final IgnoredFieldType FIELD_TYPE = new IgnoredFieldType();
    private static final IgnoredFieldMapper INSTANCE = new IgnoredFieldMapper();
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> INSTANCE);

    private IgnoredFieldMapper() {
        super(FIELD_TYPE);
    }

    @Override
    public void postParse(DocumentParserContext context) {
        for (String field : context.getIgnoredFields()) {
            context.doc().add((IndexableField)new Field("_ignored", (CharSequence)field, (IndexableFieldType)Defaults.FIELD_TYPE));
        }
    }

    @Override
    protected String contentType() {
        return "_ignored";
    }

    @Override
    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    public static final class IgnoredFieldType
    extends StringFieldType {
        private IgnoredFieldType() {
            super("_ignored", true, true, false, TextSearchInfo.SIMPLE_MATCH_ONLY, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return "_ignored";
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new TermRangeQuery(this.name(), null, null, true, true);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return new StoredValueFetcher(context.lookup(), "_ignored");
        }
    }

    public static class Defaults {
        public static final String NAME = "_ignored";
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

