/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.mapper.DynamicFieldType;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RuntimeField;

final class FieldTypeLookup {
    private final Map<String, MappedFieldType> fullNameToFieldType;
    private final Map<String, DynamicFieldType> dynamicFieldTypes;
    private final Map<String, Set<String>> fieldToCopiedFields;
    private final int maxParentPathDots;

    FieldTypeLookup(Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Collection<RuntimeField> runtimeFields) {
        HashMap<String, MappedFieldType> fullNameToFieldType = new HashMap<String, MappedFieldType>();
        HashMap<String, DynamicFieldType> dynamicFieldTypes = new HashMap<String, DynamicFieldType>();
        HashMap fieldToCopiedFields = new HashMap();
        for (FieldMapper fieldMapper : fieldMappers) {
            String fieldName = fieldMapper.name();
            MappedFieldType fieldType = fieldMapper.fieldType();
            fullNameToFieldType.put(fieldType.name(), fieldType);
            if (fieldType instanceof DynamicFieldType) {
                dynamicFieldTypes.put(fieldType.name(), (DynamicFieldType)((Object)fieldType));
            }
            for (String targetField : fieldMapper.copyTo().copyToFields()) {
                Set sourcePath = (Set)fieldToCopiedFields.get(targetField);
                if (sourcePath == null) {
                    HashSet<String> copiedFields = new HashSet<String>();
                    copiedFields.add(targetField);
                    fieldToCopiedFields.put(targetField, copiedFields);
                }
                ((Set)fieldToCopiedFields.get(targetField)).add(fieldName);
            }
        }
        int maxParentPathDots = 0;
        for (String dynamicRoot : dynamicFieldTypes.keySet()) {
            maxParentPathDots = Math.max(maxParentPathDots, FieldTypeLookup.dotCount(dynamicRoot));
        }
        this.maxParentPathDots = maxParentPathDots;
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            MappedFieldType fieldType = (MappedFieldType)fullNameToFieldType.get(path);
            if (fieldType == null) continue;
            fullNameToFieldType.put(aliasName, fieldType);
            if (!(fieldType instanceof DynamicFieldType)) continue;
            dynamicFieldTypes.put(aliasName, (DynamicFieldType)((Object)fieldType));
        }
        for (MappedFieldType fieldType : RuntimeField.collectFieldTypes(runtimeFields).values()) {
            fullNameToFieldType.put(fieldType.name(), fieldType);
        }
        this.fullNameToFieldType = Map.copyOf(fullNameToFieldType);
        this.dynamicFieldTypes = Map.copyOf(dynamicFieldTypes);
        fieldToCopiedFields.entrySet().forEach(e -> e.setValue(Set.copyOf((Collection)e.getValue())));
        this.fieldToCopiedFields = Map.copyOf(fieldToCopiedFields);
    }

    private static int dotCount(String path) {
        int dotCount = 0;
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '.') continue;
            ++dotCount;
        }
        return dotCount;
    }

    MappedFieldType get(String field) {
        MappedFieldType fieldType = this.fullNameToFieldType.get(field);
        if (fieldType != null) {
            return fieldType;
        }
        return this.getDynamicField(field);
    }

    int getMaxParentPathDots() {
        return this.maxParentPathDots;
    }

    private MappedFieldType getDynamicField(String field) {
        String parentField;
        DynamicFieldType dft;
        if (this.dynamicFieldTypes.isEmpty()) {
            return null;
        }
        int dotIndex = -1;
        int fieldDepth = -1;
        do {
            if (++fieldDepth > this.maxParentPathDots) {
                return null;
            }
            if ((dotIndex = field.indexOf(46, dotIndex + 1)) >= 0) continue;
            return null;
        } while ((dft = this.dynamicFieldTypes.get(parentField = field.substring(0, dotIndex))) == null || Objects.equals(field, parentField));
        String key = field.substring(dotIndex + 1);
        return dft.getChildFieldType(key);
    }

    Set<String> getMatchingFieldNames(String pattern) {
        if (Regex.isMatchAllPattern(pattern)) {
            return Collections.unmodifiableSet(this.fullNameToFieldType.keySet());
        }
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return this.get(pattern) == null ? Collections.emptySet() : Collections.singleton(pattern);
        }
        return this.fullNameToFieldType.keySet().stream().filter(field -> Regex.simpleMatch(pattern, field)).collect(Collectors.toUnmodifiableSet());
    }

    Set<String> sourcePaths(String field) {
        String parentField;
        if (this.fullNameToFieldType.isEmpty()) {
            return Set.of();
        }
        MappedFieldType fieldType = this.getDynamicField(field);
        if (fieldType != null) {
            return Set.of(field);
        }
        String resolvedField = field;
        int lastDotIndex = field.lastIndexOf(46);
        if (lastDotIndex > 0 && this.fullNameToFieldType.containsKey(parentField = field.substring(0, lastDotIndex))) {
            resolvedField = parentField;
        }
        return this.fieldToCopiedFields.containsKey(resolvedField) ? this.fieldToCopiedFields.get(resolvedField) : Set.of(resolvedField);
    }
}

